/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.io;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.search.lookup.SourceLookup;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class JsonDocumentModelReader {
    private static final Log log = LogFactory.getLog(JsonDocumentModelReader.class);
    private final Map<String, Object> source;
    private String sid;

    public JsonDocumentModelReader(String json) {
        byte[] bytes = json.getBytes();
        this.source = SourceLookup.sourceAsMap((BytesReference)new BytesArray(bytes, 0, bytes.length));
    }

    public JsonDocumentModelReader(Map<String, Object> source) {
        this.source = source;
    }

    public JsonDocumentModelReader session(CoreSession session) {
        this.sid = session.getSessionId();
        return this;
    }

    public JsonDocumentModelReader sid(String sid) {
        this.sid = sid;
        return this;
    }

    public DocumentModel getDocumentModel() {
        assert (this.source != null);
        String type = (String)((Object)this.getProperty("ecm:primaryType"));
        List mixinTypes = (List)((Object)this.getProperty("ecm:mixinType"));
        String id = (String)((Object)this.getProperty("ecm:uuid"));
        String path = (String)((Object)this.getProperty("ecm:path"));
        String parentId = (String)((Object)this.getProperty("ecm:parentId"));
        String repositoryName = (String)((Object)this.getProperty("ecm:repository"));
        boolean isProxy = Boolean.TRUE.equals(this.getProperty("ecm:isProxy"));
        String sourceId = null;
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType docType = schemaManager.getDocumentType(type);
        HashSet facets = new HashSet(mixinTypes == null ? Collections.emptyList() : mixinTypes);
        facets.remove("Immutable");
        facets.removeAll(docType.getFacets());
        Path pathObj = path == null ? null : new Path(path);
        IdRef docRef = new IdRef(id);
        IdRef parentRef = parentId == null ? null : new IdRef(parentId);
        DocumentModelImpl doc = new DocumentModelImpl(this.sid, type, id, pathObj, (DocumentRef)docRef, (DocumentRef)parentRef, null, facets, sourceId, repositoryName, isProxy);
        for (String schemaName : doc.getSchemas()) {
            Object schema = schemaManager.getSchema(schemaName);
            doc.addDataModel(DocumentModelFactory.createDataModel(null, (Schema)schema));
        }
        for (String prop : this.source.keySet()) {
            String schema = prop.split(":")[0];
            Serializable value = this.getProperty(prop);
            if (value == null) continue;
            if ("ecm".equals(schema)) {
                switch (prop) {
                    case "ecm:currentLifeCycleState": {
                        doc.prefetchCurrentLifecycleState((String)((Object)value));
                        break;
                    }
                }
                continue;
            }
            try {
                doc.setPropertyValue(prop, value);
            }
            catch (PropertyException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("fetchDocFromEs can not set property %s to %s", prop, value));
            }
        }
        doc.setIsImmutable(true);
        return doc;
    }

    protected Serializable getProperty(String name) {
        return (Serializable)this.source.get(name);
    }
}

