/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.io.marshallers.json;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.model.impl.PropertyFactory;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.elasticsearch.aggregate.SignificantTermAggregate;
import org.nuxeo.elasticsearch.aggregate.TermAggregate;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AggregateJsonWriter
extends ExtensibleEntityJsonWriter<Aggregate> {
    private static final Log log = LogFactory.getLog(AggregateJsonWriter.class);
    public static final String ENTITY_TYPE = "aggregate";
    public static final String FETCH_KEY = "key";
    @Inject
    private SchemaManager schemaManager;

    public AggregateJsonWriter() {
        super(ENTITY_TYPE, Aggregate.class);
    }

    public AggregateJsonWriter(String entityType, Class<Aggregate> entityClass) {
        super(entityType, entityClass);
    }

    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    protected void writeEntityBody(Aggregate agg, JsonGenerator jg) throws IOException {
        boolean fetch = this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_KEY);
        jg.writeObjectField("id", (Object)agg.getId());
        jg.writeObjectField("field", (Object)agg.getField());
        jg.writeObjectField("properties", (Object)agg.getProperties());
        jg.writeObjectField("ranges", (Object)agg.getRanges());
        jg.writeObjectField("selection", (Object)agg.getSelection());
        jg.writeObjectField("type", (Object)agg.getType());
        if (!fetch || !(agg instanceof TermAggregate) && !(agg instanceof SignificantTermAggregate)) {
            jg.writeObjectField("buckets", (Object)agg.getBuckets());
            jg.writeObjectField("extendedBuckets", (Object)agg.getExtendedBuckets());
        } else {
            String fieldName = agg.getField();
            Field field = this.schemaManager.getField(fieldName);
            if (field != null) {
                try (Closeable resource = this.ctx.wrap().with("fetch.document", (Object)"properties").with("fetch.directoryEntry", (Object)"parent").with("translate.directoryEntry", (Object)"label").with("depth", (Object)"max").open();){
                    this.writeBuckets("buckets", agg.getBuckets(), field, jg);
                    this.writeBuckets("extendedBuckets", agg.getExtendedBuckets(), field, jg);
                }
            } else {
                log.warn((Object)String.format("Could not resolve field %s for aggrgeate %s", fieldName, agg.getId()));
                jg.writeObjectField("buckets", (Object)agg.getBuckets());
                jg.writeObjectField("extendedBuckets", (Object)agg.getExtendedBuckets());
            }
        }
    }

    protected void writeBuckets(String fieldName, List<Bucket> buckets, Field field, JsonGenerator jg) throws IOException, JsonGenerationException {
        Schema schema = field.getDeclaringType().getSchema();
        DocumentPartImpl part = new DocumentPartImpl(schema);
        jg.writeArrayFieldStart(fieldName);
        for (Bucket bucket : buckets) {
            BucketRange bucketRange;
            jg.writeStartObject();
            jg.writeObjectField(FETCH_KEY, (Object)bucket.getKey());
            Property prop = PropertyFactory.createProperty((Property)part, (Field)field, (int)0);
            if (prop.isList()) {
                ListType t = (ListType)prop.getType();
                t.getField();
                prop = PropertyFactory.createProperty((Property)part, (Field)t.getField(), (int)0);
            }
            log.debug((Object)String.format("Writing %s for field %s resolved to %s", fieldName, field.getName().toString(), prop.getName()));
            prop.setValue((Object)bucket.getKey());
            this.writeEntityField("fetchedKey", prop, jg);
            jg.writeNumberField("docCount", bucket.getDocCount());
            jg.writeEndObject();
            if (bucket instanceof BucketRange) {
                bucketRange = (BucketRange)bucket;
                jg.writeNumberField("from", bucketRange.getFrom().doubleValue());
                jg.writeNumberField("to", bucketRange.getTo().doubleValue());
            }
            if (!(bucket instanceof BucketRangeDate)) continue;
            bucketRange = (BucketRangeDate)bucket;
            jg.writeStringField("fromAsDate", DateParser.formatW3CDateTime((Date)bucketRange.getFromAsDate().toDate()));
            jg.writeStringField("toAsDate", DateParser.formatW3CDateTime((Date)bucketRange.getToAsDate().toDate()));
        }
        jg.writeEndArray();
    }
}

