/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.commands.IndexingCommands;
import org.nuxeo.elasticsearch.commands.IndexingCommandsStacker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchInlineListener
extends IndexingCommandsStacker
implements EventListener,
Synchronization {
    private static final Log log = LogFactory.getLog(ElasticSearchInlineListener.class);
    protected static ThreadLocal<Map<String, IndexingCommands>> transactionCommands = new ThreadLocal<Map<String, IndexingCommands>>(){

        @Override
        protected HashMap<String, IndexingCommands> initialValue() {
            return new HashMap<String, IndexingCommands>();
        }
    };
    protected static ThreadLocal<Boolean> isEnlisted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    public static ThreadLocal<Boolean> useSyncIndexing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        public void set(Boolean value) {
            super.set(value);
            if (Boolean.TRUE.equals(value)) {
                for (IndexingCommands cmds : transactionCommands.get().values()) {
                    for (IndexingCommand cmd : cmds.getCommands()) {
                        cmd.makeSync();
                    }
                }
            }
        }
    };

    @Override
    protected Map<String, IndexingCommands> getAllCommands() {
        return transactionCommands.get();
    }

    @Override
    protected boolean isSyncIndexingByDefault() {
        Boolean ret = useSyncIndexing.get();
        if (ret == null) {
            ret = false;
        }
        return ret;
    }

    public void handleEvent(Event event) {
        String eventId = event.getName();
        if (!isEnlisted.get().booleanValue()) {
            if (event.isCommitEvent()) {
                this.afterCompletion(3);
                return;
            }
            isEnlisted.set(this.registerSynchronization(this));
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        this.stackCommand(docCtx, eventId);
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        try {
            if (this.getAllCommands().isEmpty()) {
                return;
            }
            if (1 == status || 4 == status) {
                return;
            }
            ArrayList<IndexingCommand> commandList = new ArrayList<IndexingCommand>();
            for (IndexingCommands cmds : this.getAllCommands().values()) {
                for (IndexingCommand cmd : cmds.getCommands()) {
                    commandList.add(cmd);
                }
            }
            ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
            esi.runIndexingWorker(commandList);
        }
        finally {
            isEnlisted.set(false);
            this.getAllCommands().clear();
            useSyncIndexing.set(null);
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm != null) {
                if (tm.getTransaction() != null) {
                    tm.getTransaction().registerSynchronization(sync);
                    return true;
                }
                if (!Framework.isTestModeSet()) {
                    log.error((Object)"Unable to register synchronization : no active transaction");
                }
                return false;
            }
            log.error((Object)"Unable to register synchronization : no TransactionManager");
            return false;
        }
        catch (IllegalStateException | NamingException | RollbackException | SystemException e) {
            log.error((Object)"Unable to register synchronization", e);
            return false;
        }
    }
}

