/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.shield;

import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.ShieldPlugin;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.elasticsearch.core.ESClientInitializationServiceImpl;

public class ShieldInitializationService
extends ESClientInitializationServiceImpl {
    @Override
    protected Settings.Builder initializeSettingsBuilder(ElasticSearchRemoteConfig config) {
        Settings.Builder builder = super.initializeSettingsBuilder(config);
        builder.put("shield.user", this.getUsername() + ":" + this.getPassword());
        String sslKeystorePath = this.getSslKeystorePath();
        String sslKeystorePassword = this.getSslKeystorePassword();
        if (sslKeystorePath != null && sslKeystorePassword != null) {
            builder.put("shield.ssl.keystore.path", sslKeystorePath).put("shield.ssl.keystore.password", sslKeystorePassword).put("shield.transport.ssl", "true");
        }
        return builder;
    }

    @Override
    protected TransportClient.Builder initializeClientBuilder() {
        return super.initializeClientBuilder().addPlugin(ShieldPlugin.class);
    }
}

