/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.elasticsearch.work.BucketIndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ScrollingIndexingWorker
extends BaseIndexingWorker
implements Work {
    private static final Log log = LogFactory.getLog(ScrollingIndexingWorker.class);
    private static final long serialVersionUID = -4507677669419340384L;
    private static final String DEFAULT_BUCKET_SIZE = "500";
    private static final long WARN_DOC_COUNT = 500L;
    protected final String nxql;
    protected transient WorkManager workManager;
    protected long documentCount = 0L;

    public ScrollingIndexingWorker(String repositoryName, String nxql) {
        this.repositoryName = repositoryName;
        this.nxql = nxql;
    }

    public String getTitle() {
        return "Elasticsearch scrolling indexer: " + this.nxql + ", processed " + this.documentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWork() {
        boolean warnAtEnd;
        int bucketCount;
        String jobName;
        block10: {
            jobName = this.getSchedulePath().getPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Re-indexing job: %s started, NXQL: %s on repository: %s", jobName, this.nxql, this.repositoryName));
            }
            this.openSystemSession();
            int bucketSize = this.getBucketSize();
            ScrollResult ret = this.session.scroll(this.nxql, bucketSize, 60);
            bucketCount = 0;
            warnAtEnd = false;
            try {
                while (ret.hasResults()) {
                    this.documentCount += (long)ret.getResultIds().size();
                    this.scheduleBucketWorker(ret.getResultIds(), false);
                    ++bucketCount;
                    ret = this.session.scroll(ret.getScrollId());
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                }
                if (this.documentCount <= 500L) break block10;
                warnAtEnd = true;
                this.scheduleBucketWorker(Collections.emptyList(), warnAtEnd);
            }
            catch (Throwable throwable) {
                if (warnAtEnd || log.isDebugEnabled()) {
                    String message = String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount);
                    if (warnAtEnd) {
                        log.warn((Object)message);
                    } else {
                        log.debug((Object)message);
                    }
                }
                throw throwable;
            }
        }
        if (warnAtEnd || log.isDebugEnabled()) {
            String message = String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount);
            if (warnAtEnd) {
                log.warn((Object)message);
            } else {
                log.debug((Object)message);
            }
        }
    }

    protected void scheduleBucketWorker(List<String> bucket, boolean isLast) {
        if (bucket.isEmpty()) {
            return;
        }
        BucketIndexingWorker subWorker = new BucketIndexingWorker(this.repositoryName, bucket, isLast);
        this.getWorkManager().schedule((Work)subWorker);
    }

    protected WorkManager getWorkManager() {
        if (this.workManager == null) {
            this.workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        }
        return this.workManager;
    }

    protected int getBucketSize() {
        String value = Framework.getProperty((String)"elasticsearch.reindex.bucketReadSize", (String)DEFAULT_BUCKET_SIZE);
        return Integer.parseInt(value);
    }
}

