/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.ExitException;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.scripting.Expression;

public class OperationChainCompiler {
    protected final AutomationService service;
    protected final Map<Connector, OperationMethod> cache = new ConcurrentHashMap<Connector, OperationMethod>();

    protected OperationChainCompiler(AutomationService service) {
        this.service = service;
    }

    public CompiledChain compile(ChainTypeImpl typeof, Class<?> typein) throws OperationException {
        Connector connector = new Connector(typeof, typein);
        if (!this.cache.containsKey(connector)) {
            this.cache.put(connector, connector.connect());
        }
        return new CompiledChainImpl(typeof, typein, this.cache.get(connector));
    }

    protected class CompiledChainImpl
    implements CompiledChain {
        protected final ChainTypeImpl typeof;
        protected final Class<?> typein;
        protected final OperationMethod head;

        protected CompiledChainImpl(ChainTypeImpl typeof, Class<?> typein, OperationMethod head) {
            this.typeof = typeof;
            this.typein = typein;
            this.head = head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(OperationContext ctx) throws OperationException {
            ctx.push(this.typeof.getChainParameters());
            try {
                ctx.getCallback().onChainEnter(this.typeof);
                try {
                    Object object = this.head.invoke(ctx);
                    ctx.getCallback().onChainExit();
                    return object;
                }
                catch (ExitException e) {
                    try {
                        if (e.isRollback()) {
                            ctx.setRollback();
                        }
                        Object object = ctx.getInput();
                        ctx.getCallback().onChainExit();
                        ctx.pop(this.typeof.getChainParameters());
                        return object;
                    }
                    catch (Throwable throwable) {
                        ctx.getCallback().onChainExit();
                        throw throwable;
                    }
                }
            }
            finally {
                ctx.pop(this.typeof.getChainParameters());
            }
        }

        public String toString() {
            return "CompiledChainImpl [op=" + this.typeof + "," + "input=" + this.typein + "]";
        }
    }

    protected class OperationMethod {
        protected final OperationType typeof;
        protected final OperationParameters params;
        protected InvokableMethod method;
        protected OperationMethod prev;
        protected OperationMethod next;

        protected OperationMethod(OperationParameters params, OperationMethod prev) throws OperationNotFoundException {
            this.typeof = OperationChainCompiler.this.service.getOperation(params.id());
            this.params = params;
            this.prev = prev;
        }

        protected Object invoke(OperationContext context) throws OperationException {
            context.getCallback().onOperationEnter(context, this.typeof, this.method, this.params.map());
            Object output = this.method.invoke(context, this.params.map());
            if (output instanceof Expression) {
                output = ((Expression)output).eval(context);
            }
            context.getCallback().onOperationExit(output);
            context.setInput(output);
            if (this.next != null) {
                return this.next.invoke(context);
            }
            return output;
        }

        void solve(Class<?> in) throws InvalidChainException {
            InvokableMethod[] methods = this.typeof.getMethodsMatchingInput(in);
            if (methods == null) {
                throw new InvalidChainException("Cannot find any valid path in operation chain - no method found for operation '" + this.typeof.getId() + "' and for first input type '" + in.getName() + "'");
            }
            if (this.next == null) {
                this.method = methods[0];
                return;
            }
            for (InvokableMethod m : methods) {
                Class<?> nextIn = m.getOutputType();
                if (nextIn == Void.TYPE || nextIn.equals(Object.class)) {
                    nextIn = in;
                }
                try {
                    this.next.solve(nextIn);
                    this.method = m;
                    return;
                }
                catch (InvalidChainException invalidChainException) {
                }
            }
            throw new InvalidChainException("Cannot find any valid path in operation chain - no method found for operation '" + this.typeof.getId() + "' and for first input type '" + in.getName() + "'");
        }
    }

    protected class Connector {
        protected final ChainTypeImpl typeof;
        protected final Class<?> typein;
        protected final int hashcode;

        protected Connector(ChainTypeImpl typeof, Class<?> typein) {
            this.typeof = typeof;
            this.typein = typein;
            this.hashcode = this.hashcode(typeof, typein);
        }

        protected int hashcode(OperationType typeof, Class<?> typein) {
            int prime = 31;
            int result = 1;
            result = prime * result + typeof.hashCode();
            result = prime * result + typein.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Connector)) {
                return false;
            }
            Connector other = (Connector)obj;
            return this.hashcode == other.hashcode;
        }

        protected OperationMethod connect() throws OperationException {
            OperationMethod head = null;
            OperationMethod prev = null;
            for (OperationParameters params : this.typeof.chain.getOperations()) {
                OperationMethod next = new OperationMethod(params, prev);
                if (prev != null) {
                    prev.next = next;
                }
                if (next.prev == null) {
                    head = next;
                }
                prev = next;
            }
            head.solve(this.typein);
            return head;
        }
    }
}

