/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import java.io.IOException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

@Operation(id="RunInputScript", category="Scripting", label="Run Input Script", description="Run a script from the input blob. A blob comtaining script result is returned.", aliases={"Context.RunInputScript"})
public class RunInputScript {
    public static final String ID = "RunInputScript";
    @Context
    protected OperationContext ctx;
    @Param(name="type", required=false, values={"mvel", "groovy"}, widget="Option")
    protected String type = "mvel";

    @OperationMethod
    public Blob run(Blob blob) throws OperationException, IOException {
        if (!((NuxeoPrincipal)this.ctx.getPrincipal()).isAdministrator()) {
            throw new OperationException("Not allowed. You must be administrator to run scripts");
        }
        Object r = null;
        if (this.type.equals("mvel")) {
            r = Scripting.MvelScript.compile(blob.getString()).eval(this.ctx);
        } else if (this.type.equals("groovy")) {
            r = new Scripting.GroovyScript(blob.getString()).eval(this.ctx);
        } else {
            throw new OperationException("Unknown scripting language " + this.type);
        }
        if (r != null) {
            Blob b = Blobs.createBlob((String)r.toString());
            b.setFilename("result");
            return b;
        }
        return null;
    }
}

