/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.rounding.TimeZoneRounding;

public abstract class Rounding
implements Streamable {
    public abstract byte id();

    public abstract long roundKey(long var1);

    public abstract long valueForKey(long var1);

    public final long round(long value) {
        return this.valueForKey(this.roundKey(value));
    }

    public abstract long nextRoundingValue(long var1);

    public static class Streams {
        public static void write(Rounding rounding, StreamOutput out) throws IOException {
            out.writeByte(rounding.id());
            rounding.writeTo(out);
        }

        public static Rounding read(StreamInput in) throws IOException {
            Rounding rounding = null;
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    rounding = new Interval();
                    break;
                }
                case 1: {
                    rounding = new TimeZoneRounding.TimeUnitRounding();
                    break;
                }
                case 2: {
                    rounding = new TimeZoneRounding.TimeIntervalRounding();
                    break;
                }
                case 7: {
                    rounding = new FactorRounding();
                    break;
                }
                case 8: {
                    rounding = new OffsetRounding();
                    break;
                }
                default: {
                    throw new ElasticsearchException("unknown rounding id [" + id + "]", new Object[0]);
                }
            }
            rounding.readFrom(in);
            return rounding;
        }
    }

    public static class OffsetRounding
    extends Rounding {
        static final byte ID = 8;
        private Rounding rounding;
        private long offset;

        OffsetRounding() {
        }

        public OffsetRounding(Rounding intervalRounding, long offset) {
            this.rounding = intervalRounding;
            this.offset = offset;
        }

        @Override
        public byte id() {
            return 8;
        }

        @Override
        public long roundKey(long value) {
            return this.rounding.roundKey(value - this.offset);
        }

        @Override
        public long valueForKey(long key) {
            return this.offset + this.rounding.valueForKey(key);
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.rounding.nextRoundingValue(value - this.offset) + this.offset;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.rounding = Streams.read(in);
            this.offset = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Streams.write(this.rounding, out);
            out.writeLong(this.offset);
        }
    }

    public static class FactorRounding
    extends Rounding {
        static final byte ID = 7;
        private Rounding rounding;
        private float factor;

        FactorRounding() {
        }

        FactorRounding(Rounding rounding, float factor) {
            this.rounding = rounding;
            this.factor = factor;
        }

        @Override
        public byte id() {
            return 7;
        }

        @Override
        public long roundKey(long utcMillis) {
            return this.rounding.roundKey((long)(this.factor * (float)utcMillis));
        }

        @Override
        public long valueForKey(long key) {
            return this.rounding.valueForKey(key);
        }

        @Override
        public long nextRoundingValue(long value) {
            return this.rounding.nextRoundingValue(value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.rounding = (TimeZoneRounding)Streams.read(in);
            this.factor = in.readFloat();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Streams.write(this.rounding, out);
            out.writeFloat(this.factor);
        }
    }

    public static class Interval
    extends Rounding {
        static final byte ID = 0;
        private long interval;

        public Interval() {
        }

        public Interval(long interval) {
            this.interval = interval;
        }

        @Override
        public byte id() {
            return 0;
        }

        public static long roundKey(long value, long interval) {
            if (value < 0L) {
                return (value - interval + 1L) / interval;
            }
            return value / interval;
        }

        public static long roundValue(long key, long interval) {
            return key * interval;
        }

        @Override
        public long roundKey(long value) {
            return Interval.roundKey(value, this.interval);
        }

        @Override
        public long valueForKey(long key) {
            return key * this.interval;
        }

        @Override
        public long nextRoundingValue(long value) {
            assert (value == this.round(value));
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
        }
    }
}

