/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanTermQueryParser
implements QueryParser {
    public static final String NAME = "span_term";

    @Inject
    public SpanTermQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        String value = null;
        float boost = 1.0f;
        String queryName = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("term".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[span_term] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            parser.nextToken();
        } else {
            value = parser.text();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "No value specified for term query", new Object[0]);
        }
        BytesRef valueBytes = null;
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType != null) {
            fieldName = fieldType.names().indexName();
            valueBytes = fieldType.indexedValueForSearch(value);
        }
        if (valueBytes == null) {
            valueBytes = new BytesRef((CharSequence)value);
        }
        SpanTermQuery query = new SpanTermQuery(new Term(fieldName, valueBytes));
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, (Query)query);
        }
        return query;
    }
}

