/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.Template;
import org.elasticsearch.search.internal.SearchContext;

public class TemplateQueryParser
implements QueryParser {
    public static final String NAME = "template";
    public static final String QUERY = "query";
    private final ScriptService scriptService;
    private static final Map<String, ScriptService.ScriptType> parametersToTypes = new HashMap<String, ScriptService.ScriptType>();

    @Inject
    public TemplateQueryParser(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    @Nullable
    public Query parse(QueryParseContext parseContext) throws IOException {
        XContentParser parser = parseContext.parser();
        Template template = TemplateQueryParser.parse(parser, parseContext.parseFieldMatcher());
        ExecutableScript executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, SearchContext.current(), Collections.emptyMap());
        BytesReference querySource = (BytesReference)executable.run();
        try (XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);){
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParserService());
            context.reset(qSourceParser);
            Query query = context.parseInnerQuery();
            return query;
        }
    }

    public static Template parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, String ... parameters) throws IOException {
        HashMap<String, ScriptService.ScriptType> parameterMap = new HashMap<String, ScriptService.ScriptType>(parametersToTypes);
        for (String parameter : parameters) {
            parameterMap.put(parameter, ScriptService.ScriptType.INLINE);
        }
        return TemplateQueryParser.parse(parser, parameterMap, parseFieldMatcher);
    }

    public static Template parse(String defaultLang, XContentParser parser, ParseFieldMatcher parseFieldMatcher, String ... parameters) throws IOException {
        HashMap<String, ScriptService.ScriptType> parameterMap = new HashMap<String, ScriptService.ScriptType>(parametersToTypes);
        for (String parameter : parameters) {
            parameterMap.put(parameter, ScriptService.ScriptType.INLINE);
        }
        return Template.parse(parser, parameterMap, defaultLang, parseFieldMatcher);
    }

    public static Template parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return TemplateQueryParser.parse(parser, parametersToTypes, parseFieldMatcher);
    }

    public static Template parse(XContentParser parser, Map<String, ScriptService.ScriptType> parameterMap, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Template.parse(parser, parameterMap, parseFieldMatcher);
    }

    static {
        parametersToTypes.put(QUERY, ScriptService.ScriptType.INLINE);
        parametersToTypes.put("file", ScriptService.ScriptType.FILE);
        parametersToTypes.put("id", ScriptService.ScriptType.INDEXED);
    }
}

