/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.preview.adapter.ImagePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MarkdownPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.OfficePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.PdfPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.PlainImagePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterManager;
import org.nuxeo.ecm.platform.preview.adapter.base.AbstractHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.NothingToPreviewException;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ConverterBasedHtmlPreviewAdapter
extends AbstractHtmlPreviewAdapter {
    private static final Logger log = LogManager.getLogger(ConverterBasedHtmlPreviewAdapter.class);
    public static final String OLD_PREVIEW_PROPERTY = "nuxeo.old.jsf.preview";
    public static final String TEXT_ANNOTATIONS_PROPERTY = "nuxeo.text.annotations";
    protected String defaultFieldXPath;
    protected MimetypeRegistry mimeTypeService;
    protected static final String ALLOW_ZIP_PREVIEW = "nuxeo.preview.zip.enabled";

    public ConversionService getConversionService() {
        return (ConversionService)Framework.getService(ConversionService.class);
    }

    @Override
    protected PreviewAdapterManager getPreviewManager() {
        return (PreviewAdapterManager)Framework.getService(PreviewAdapterManager.class);
    }

    protected static String getMimeType(Blob blob) {
        if (blob == null) {
            return null;
        }
        String srcMT = blob.getMimeType();
        if (srcMT == null || srcMT.startsWith("application/octet-stream")) {
            try {
                MimetypeRegistry mtr = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                srcMT = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "application/octet-stream");
                log.debug("mime type service returned " + srcMT);
            }
            catch (MimetypeDetectionException e) {
                log.warn("error while calling Mimetype service", (Throwable)e);
            }
        }
        return srcMT;
    }

    protected String getMimeType(String xpath) {
        BlobHolder blobHolder2preview = this.getBlobHolder2preview(xpath);
        Blob blob = this.getBlob2preview(blobHolder2preview);
        return ConverterBasedHtmlPreviewAdapter.getMimeType(blob);
    }

    protected String getDefaultPreviewFieldXPath() {
        return this.defaultFieldXPath;
    }

    public void setDefaultPreviewFieldXPath(String xPath) {
        this.defaultFieldXPath = xPath;
    }

    @Override
    public List<Blob> getPreviewBlobs() throws PreviewException {
        return this.getPreviewBlobs(this.getDefaultPreviewFieldXPath());
    }

    @Override
    public boolean hasPreview(String xpath) {
        String srcMT;
        try {
            srcMT = this.getMimeType(xpath);
        }
        catch (NothingToPreviewException e) {
            return false;
        }
        if ("application/zip".equals(srcMT) && !((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(ALLOW_ZIP_PREVIEW)) {
            return false;
        }
        MimeTypePreviewer mtPreviewer = this.getPreviewManager().getPreviewer(srcMT);
        return mtPreviewer != null || this.getConversionService().getConverterName(srcMT, "text/html") != null;
    }

    @Override
    public List<Blob> getPreviewBlobs(String xpath) throws PreviewException {
        List<Blob> result;
        Blob blob2Preview;
        BlobHolder blobHolder2preview = this.getBlobHolder2preview(xpath);
        try {
            blob2Preview = this.getBlob2preview(blobHolder2preview);
        }
        catch (NothingToPreviewException e) {
            return Collections.emptyList();
        }
        String srcMT = this.getMimeType(xpath);
        log.debug("Source type for HTML preview =" + srcMT);
        MimeTypePreviewer mtPreviewer = this.getPreviewManager().getPreviewer(srcMT);
        if (mtPreviewer != null && (result = this.getPreviewFromMimeTypePreviewer(mtPreviewer, blob2Preview)) != null) {
            return result;
        }
        String converterName = this.getConversionService().getConverterName(srcMT, "text/html");
        if (converterName == null) {
            log.debug("No dedicated converter found, using generic");
            converterName = "any2html";
        }
        try {
            BlobHolder result2 = this.getConversionService().convert(converterName, blobHolder2preview, null);
            this.setMimeType(result2);
            this.setDigest(result2);
            return result2.getBlobs();
        }
        catch (ConversionException e) {
            throw new PreviewException(e.getMessage(), e);
        }
    }

    protected List<Blob> getPreviewFromMimeTypePreviewer(MimeTypePreviewer mtPreviewer, Blob blob2Preview) {
        boolean oldPreview = Boolean.TRUE.equals(this.adaptedDoc.getContextData(OLD_PREVIEW_PROPERTY));
        if (!oldPreview) {
            return mtPreviewer.getPreview(blob2Preview, this.adaptedDoc);
        }
        if (mtPreviewer instanceof ImagePreviewer) {
            return new PlainImagePreviewer().getPreview(blob2Preview, this.adaptedDoc);
        }
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (cs.isBooleanPropertyTrue(TEXT_ANNOTATIONS_PROPERTY) && (mtPreviewer instanceof PdfPreviewer || mtPreviewer instanceof MarkdownPreviewer || mtPreviewer instanceof OfficePreviewer)) {
            return null;
        }
        return mtPreviewer.getPreview(blob2Preview, this.adaptedDoc);
    }

    private Blob getBlob2preview(BlobHolder blobHolder2preview) throws PreviewException {
        Blob blob2Preview;
        try {
            blob2Preview = blobHolder2preview.getBlob();
        }
        catch (PropertyNotFoundException e) {
            blob2Preview = null;
        }
        if (blob2Preview == null) {
            throw new NothingToPreviewException("Can not preview a document without blob");
        }
        return blob2Preview;
    }

    private BlobHolder getBlobHolder2preview(String xpath) {
        if (xpath == null || "default".equals(xpath)) {
            return (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class);
        }
        return new DocumentBlobHolder(this.adaptedDoc, xpath);
    }

    protected void setMimeType(BlobHolder result) {
        for (Blob blob : result.getBlobs()) {
            if (blob.getMimeType() != null && !blob.getMimeType().startsWith("application/octet-stream") || !blob.getFilename().endsWith("html")) continue;
            String mimeTpye = ConverterBasedHtmlPreviewAdapter.getMimeType(blob);
            blob.setMimeType(mimeTpye);
        }
    }

    protected void setDigest(BlobHolder result) {
        for (Blob blob : result.getBlobs()) {
            if (blob.getDigest() != null) continue;
            try {
                InputStream stream = blob.getStream();
                Throwable throwable = null;
                try {
                    String digest = DigestUtils.md5Hex((InputStream)stream);
                    blob.setDigest(digest);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to compute digest of blob.", (Throwable)e);
            }
        }
    }

    public String getMimeType(File file) throws ConversionException {
        try {
            return this.getMimeTypeService().getMimetypeFromFile(file);
        }
        catch (ConversionException e) {
            throw new ConversionException("Could not get MimeTypeRegistry");
        }
        catch (MimetypeDetectionException | MimetypeNotFoundException e) {
            return "application/octet-stream";
        }
    }

    public MimetypeRegistry getMimeTypeService() throws ConversionException {
        if (this.mimeTypeService == null) {
            this.mimeTypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimeTypeService;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean cachable() {
        return true;
    }

    @Override
    public boolean hasBlobToPreview() throws PreviewException {
        Blob blob2Preview;
        String xpath = this.getDefaultPreviewFieldXPath();
        try {
            blob2Preview = this.getBlob2preview(this.getBlobHolder2preview(xpath));
        }
        catch (NothingToPreviewException e) {
            return false;
        }
        String srcMT = this.getMimeType(xpath);
        if ("application/zip".equals(srcMT) && !((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(ALLOW_ZIP_PREVIEW)) {
            return false;
        }
        return blob2Preview != null;
    }
}

