/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.helper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.platform.preview.adapter.base.ConverterBasedHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PreviewHelper {
    public static final String REST_API_PREFIX = "site/api/v1";
    protected static final Map<String, Boolean> hasPreviewByType = new ConcurrentHashMap<String, Boolean>();

    private PreviewHelper() {
    }

    public static String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, null);
    }

    public static String getPreviewURL(DocumentModel doc, String xpath) {
        StringJoiner sj = new StringJoiner("/", "", "/").add(REST_API_PREFIX).add("repo").add(doc.getRepositoryName()).add("id").add(doc.getId());
        if (xpath != null) {
            sj.add("@blob").add(xpath);
        }
        String result = sj.add("@preview").toString();
        String ct = doc.getChangeToken();
        if (StringUtils.isNotBlank((CharSequence)ct)) {
            try {
                result = result + "?changeToken=" + URLEncoder.encode(ct, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PreviewException(e);
            }
        }
        return result;
    }

    public static boolean typeSupportsPreview(DocumentModel doc) {
        String docType = doc.getType();
        if (hasPreviewByType.containsKey(docType)) {
            return hasPreviewByType.get(docType);
        }
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)doc.getAdapter(HtmlPreviewAdapter.class);
        if (adapter == null) {
            hasPreviewByType.put(docType, false);
            return false;
        }
        hasPreviewByType.put(docType, true);
        return true;
    }

    public static boolean docHasBlobToPreview(DocumentModel document) throws PreviewException {
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)document.getAdapter(HtmlPreviewAdapter.class);
        return adapter != null && adapter.hasBlobToPreview();
    }

    public static boolean blobSupportsPreview(DocumentModel doc, String xpath) {
        HtmlPreviewAdapter adapter;
        if (PreviewHelper.isBlobHolder(doc, xpath)) {
            xpath = null;
        }
        return (adapter = PreviewHelper.getBlobPreviewAdapter(doc)) != null && adapter.hasPreview(xpath);
    }

    public static HtmlPreviewAdapter getBlobPreviewAdapter(DocumentModel doc) {
        ConverterBasedHtmlPreviewAdapter adapter = new ConverterBasedHtmlPreviewAdapter();
        adapter.setAdaptedDocument(doc);
        return adapter;
    }

    private static boolean isBlobHolder(DocumentModel doc, String xpath) {
        DocumentBlobHolder bh = (DocumentBlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null && bh.getXpath().equals(xpath);
    }
}

