/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.binary.metadata.api.BinaryMetadataException;
import org.nuxeo.binary.metadata.api.BinaryMetadataProcessor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class ExifToolProcessor
implements BinaryMetadataProcessor {
    private static final Log log = LogFactory.getLog(ExifToolProcessor.class);
    private static final String META_NON_USED_SOURCE_FILE = "SourceFile";
    private static final String DATE_FORMAT_PATTERN = "yyyy:MM:dd HH:mm:ss";
    private static final String EXIF_IMAGE_DATE_TIME = "EXIF:DateTime";
    private static final String EXIF_PHOTO_DATE_TIME_ORIGINAL = "EXIF:DateTimeOriginal";
    private static final String EXIF_PHOTO_DATE_TIME_DIGITIZED = "EXIF:DateTimeDigitized";
    protected final ObjectMapper jacksonMapper;
    protected final CommandLineExecutorService commandLineService;
    protected Pattern VALID_EXT = Pattern.compile("[a-zA-Z0-9]*");

    public ExifToolProcessor() {
        this.jacksonMapper = new ObjectMapper();
        this.commandLineService = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
    }

    @Override
    public Blob writeMetadata(Blob blob, Map<String, Object> metadata, boolean ignorePrefix) {
        String command = ignorePrefix ? "exiftool-write-noprefix" : "exiftool-write";
        CommandAvailability ca = this.commandLineService.getCommandAvailability(command);
        if (!ca.isAvailable()) {
            throw new BinaryMetadataException("Command '" + command + "' is not available.");
        }
        if (blob == null) {
            throw new BinaryMetadataException("The following command " + ca + " cannot be executed with a null blob");
        }
        try {
            Blob newBlob = this.getTemporaryBlob(blob);
            CmdParameters params = this.commandLineService.getDefaultCmdParameters();
            params.addNamedParameter("inFilePath", newBlob.getFile());
            params.addNamedParameter("tagList", this.getCommandTags(metadata));
            ExecResult er = this.commandLineService.execCommand(command, params);
            boolean success = er.isSuccessful();
            if (!success) {
                log.error((Object)("There was an error executing the following command: " + er.getCommandLine() + ". \n" + er.getOutput()));
                return null;
            }
            newBlob.setMimeType(blob.getMimeType());
            newBlob.setEncoding(blob.getEncoding());
            newBlob.setFilename(blob.getFilename());
            return newBlob;
        }
        catch (CommandNotAvailable commandNotAvailable) {
            throw new BinaryMetadataException("Command '" + command + "' is not available.", commandNotAvailable);
        }
        catch (IOException ioException) {
            throw new BinaryMetadataException(ioException);
        }
    }

    protected Map<String, Object> readMetadata(String command, Blob blob, List<String> metadata, boolean ignorePrefix) {
        CommandAvailability ca = this.commandLineService.getCommandAvailability(command);
        if (!ca.isAvailable()) {
            throw new BinaryMetadataException("Command '" + command + "' is not available.");
        }
        if (blob == null) {
            throw new BinaryMetadataException("The following command " + ca + " cannot be executed with a null blob");
        }
        try {
            ExecResult er;
            try (CloseableFile source = this.getTemporaryFile(blob);){
                CmdParameters params = this.commandLineService.getDefaultCmdParameters();
                params.addNamedParameter("inFilePath", source.getFile());
                if (metadata != null) {
                    params.addNamedParameter("tagList", this.getCommandTags(metadata));
                }
                er = this.commandLineService.execCommand(command, params);
            }
            return this.returnResultMap(er);
        }
        catch (CommandNotAvailable commandNotAvailable) {
            throw new RuntimeException("Command '" + command + "' is not available.", commandNotAvailable);
        }
        catch (IOException ioException) {
            throw new BinaryMetadataException(ioException);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, List<String> metadata, boolean ignorePrefix) {
        String command = ignorePrefix ? "exiftool-read-taglist-noprefix" : "exiftool-read-taglist";
        return this.readMetadata(command, blob, metadata, ignorePrefix);
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, boolean ignorePrefix) {
        String command = ignorePrefix ? "exiftool-read-noprefix" : "exiftool-read";
        return this.readMetadata(command, blob, null, ignorePrefix);
    }

    protected Map<String, Object> returnResultMap(ExecResult er) throws IOException {
        if (!er.isSuccessful()) {
            throw new BinaryMetadataException("There was an error executing the following command: " + er.getCommandLine(), (Throwable)er.getError());
        }
        StringBuilder sb = new StringBuilder();
        for (String line : er.getOutput()) {
            sb.append(line);
        }
        String jsonOutput = sb.toString();
        List resultList = (List)this.jacksonMapper.readValue(jsonOutput, (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){});
        Map resultMap = (Map)resultList.get(0);
        resultMap.remove(META_NON_USED_SOURCE_FILE);
        this.parseDates(resultMap);
        return resultMap;
    }

    protected void parseDates(Map<String, Object> resultMap) {
        for (String prop : new String[]{EXIF_IMAGE_DATE_TIME, EXIF_PHOTO_DATE_TIME_ORIGINAL, EXIF_PHOTO_DATE_TIME_DIGITIZED}) {
            Object dateObject;
            if (!resultMap.containsKey(prop) || !((dateObject = resultMap.get(prop)) instanceof String)) continue;
            SimpleDateFormat f = new SimpleDateFormat(DATE_FORMAT_PATTERN);
            try {
                Date date = f.parse((String)dateObject);
                resultMap.put(prop, date);
            }
            catch (ParseException e) {
                log.error((Object)("Could not parse property " + prop), (Throwable)e);
            }
        }
    }

    protected List<String> getCommandTags(List<String> metadataList) {
        return metadataList.stream().map(tag -> "-" + tag).collect(Collectors.toList());
    }

    protected List<String> getCommandTags(Map<String, Object> metadataMap) {
        ArrayList<String> commandTags = new ArrayList<String>();
        for (String tag : metadataMap.keySet()) {
            Object metadataValue = metadataMap.get(tag);
            if (metadataValue instanceof Collection) {
                commandTags.addAll(this.buildCommandTagsFromCollection(tag, (Collection)metadataValue));
                continue;
            }
            if (metadataValue instanceof Object[]) {
                commandTags.addAll(this.buildCommandTagsFromCollection(tag, Arrays.asList((Object[])metadataValue)));
                continue;
            }
            if (metadataValue instanceof Calendar) {
                commandTags.add(this.buildCommandTagFromDate(tag, ((Calendar)metadataValue).getTime()));
                continue;
            }
            commandTags.add(this.buildCommandTag(tag, metadataValue));
        }
        return commandTags;
    }

    private String buildCommandTag(String tag, Object value) {
        return "-" + tag + "=" + Objects.toString(value);
    }

    private List<String> buildCommandTagsFromCollection(String tag, Collection<Object> values) {
        return values.isEmpty() ? Collections.singletonList("-" + tag + "=") : values.stream().map(val -> this.buildCommandTag(tag, val)).collect(Collectors.toList());
    }

    private String buildCommandTagFromDate(String tag, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        return "-" + tag + "=" + formatter.format(date);
    }

    protected CloseableFile getTemporaryFile(Blob blob) throws IOException {
        String ext = FilenameUtils.getExtension((String)blob.getFilename());
        if (!this.VALID_EXT.matcher(ext).matches()) {
            ext = "tmp";
        }
        File tmp = Framework.createTempFile((String)"nxblob-", (String)('.' + ext));
        File file = blob.getFile();
        if (file == null) {
            try (InputStream in = blob.getStream();){
                Files.copy(in, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        tmp.delete();
        try {
            Files.createSymbolicLink(tmp.toPath(), file.toPath().toAbsolutePath(), new FileAttribute[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            Files.copy(file.toPath(), tmp.toPath(), new CopyOption[0]);
        }
        return new CloseableFile(tmp, true);
    }

    protected Blob getTemporaryBlob(Blob blob) throws IOException {
        String ext = FilenameUtils.getExtension((String)blob.getFilename());
        if (!this.VALID_EXT.matcher(ext).matches()) {
            ext = "tmp";
        }
        FileBlob newBlob = new FileBlob('.' + ext);
        File tmp = newBlob.getFile();
        File file = blob.getFile();
        if (file == null) {
            try (InputStream in = blob.getStream();){
                Files.copy(in, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            Files.copy(file.toPath(), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return newBlob;
    }
}

