/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dmk;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.internal.JDMKServerConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dmk.DmkProtocol;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DmkComponent
extends DefaultComponent {
    protected final Map<String, DmkProtocol> configs = new HashMap<String, DmkProtocol>();
    protected HtmlAdaptorServer htmlAdaptor;
    protected JDMKServerConnector httpConnector;
    protected JDMKServerConnector httpsConnector;
    protected final Log log = LogFactory.getLog(DmkComponent.class);
    protected final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    protected HtmlAdaptorServer newAdaptor(DmkProtocol config) {
        HtmlAdaptorServer adaptor = new HtmlAdaptorServer();
        adaptor.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
        adaptor.setPort(config.port);
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
            this.mbs.registerMBean(adaptor, name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        return adaptor;
    }

    protected void destroyAdaptor(HtmlAdaptorServer adaptor) {
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
            this.mbs.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        if (!adaptor.isActive()) {
            return;
        }
        adaptor.stop();
    }

    protected JDMKServerConnector newConnector(DmkProtocol config) {
        try {
            String protocol = "jdmk-".concat(config.name);
            JMXServiceURL httpURL = new JMXServiceURL(protocol, null, config.port);
            JDMKServerConnector connector = (JDMKServerConnector)JMXConnectorServerFactory.newJMXConnectorServer(httpURL, null, this.mbs);
            GenericHttpConnectorServer server = (GenericHttpConnectorServer)connector.getWrapped();
            server.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
            this.mbs.registerMBean(connector, name);
            return connector;
        }
        catch (IOException | JMException e) {
            throw new RuntimeException(e);
        }
    }

    protected void destroyConnector(JDMKServerConnector connector) {
        String protocol = connector.getAddress().getProtocol();
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
            this.mbs.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        if (!connector.isActive()) {
            return;
        }
        try {
            connector.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(ComponentContext context) {
        if (this.configs.containsKey("html")) {
            this.htmlAdaptor = this.newAdaptor(this.configs.get("html"));
            this.log.info((Object)"JMX HTML adaptor available at port 8081 (not active, to be started in JMX console)");
        }
        if (this.configs.containsKey("http")) {
            this.httpConnector = this.newConnector(this.configs.get("http"));
            this.log.info((Object)("JMX HTTP connector available at " + this.httpConnector.getAddress() + " (not active, to be started in JMX console)"));
        }
        if (this.configs.containsKey("https")) {
            this.httpsConnector = this.newConnector(this.configs.get("https"));
            this.log.info((Object)("JMX HTTPS connector available at " + this.httpConnector.getAddress() + " (not active, to be started in JMX console)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext arg0) {
        if (this.htmlAdaptor != null) {
            try {
                this.destroyAdaptor(this.htmlAdaptor);
            }
            finally {
                this.htmlAdaptor = null;
            }
        }
        if (this.httpConnector != null) {
            try {
                this.destroyConnector(this.httpConnector);
            }
            finally {
                this.httpConnector = null;
            }
        }
        if (this.httpsConnector != null) {
            try {
                this.destroyConnector(this.httpsConnector);
            }
            finally {
                this.httpsConnector = null;
            }
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("protocols".equals(extensionPoint)) {
            DmkProtocol protocol = (DmkProtocol)contribution;
            this.configs.put(protocol.name, protocol);
        }
    }
}

