/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types.localconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;

public class UITypesConfigurationAdapter
extends AbstractLocalConfiguration<UITypesConfiguration>
implements UITypesConfiguration {
    private static final Log log = LogFactory.getLog(UITypesConfigurationAdapter.class);
    protected DocumentRef documentRef;
    protected List<String> allowedTypes;
    protected List<String> deniedTypes;
    protected boolean denyAllTypes;
    protected boolean canMerge = true;
    protected String defaultType;

    public UITypesConfigurationAdapter(DocumentModel doc) {
        this.documentRef = doc.getRef();
        this.allowedTypes = this.getTypesList(doc, "uitypesconf:allowedTypes");
        this.deniedTypes = this.getTypesList(doc, "uitypesconf:deniedTypes");
        this.defaultType = this.getDefaultType(doc);
        this.denyAllTypes = this.getDenyAllTypesProperty(doc);
        if (this.denyAllTypes) {
            this.canMerge = false;
        }
    }

    protected List<String> getTypesList(DocumentModel doc, String property) {
        String[] types;
        try {
            types = (String[])doc.getPropertyValue(property);
        }
        catch (PropertyException e) {
            return Collections.emptyList();
        }
        if (types == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(types));
    }

    protected boolean getDenyAllTypesProperty(DocumentModel doc) {
        try {
            Boolean value = (Boolean)doc.getPropertyValue("uitypesconf:denyAllTypes");
            return Boolean.TRUE.equals(value);
        }
        catch (PropertyException e) {
            return false;
        }
    }

    protected String getDefaultType(DocumentModel doc) {
        String value = "File";
        try {
            value = (String)((Object)doc.getPropertyValue("uitypesconf:defaultType"));
        }
        catch (PropertyException e) {
            log.debug((Object)("can't get default type for:" + doc.getPathAsString()), (Throwable)e);
        }
        return value;
    }

    public List<String> getAllowedTypes() {
        return this.allowedTypes;
    }

    public List<String> getDeniedTypes() {
        return this.deniedTypes;
    }

    public boolean denyAllTypes() {
        return this.denyAllTypes;
    }

    public DocumentRef getDocumentRef() {
        return this.documentRef;
    }

    public boolean canMerge() {
        return this.canMerge;
    }

    public UITypesConfiguration merge(UITypesConfiguration other) {
        if (other == null) {
            return this;
        }
        this.documentRef = other.getDocumentRef();
        if (this.allowedTypes.isEmpty()) {
            this.allowedTypes = Collections.unmodifiableList(new ArrayList(other.getAllowedTypes()));
        }
        ArrayList<String> deniedTypes = new ArrayList<String>(this.deniedTypes);
        deniedTypes.addAll(other.getDeniedTypes());
        this.deniedTypes = Collections.unmodifiableList(deniedTypes);
        this.denyAllTypes = other.denyAllTypes();
        if (this.denyAllTypes) {
            this.canMerge = false;
        }
        return this;
    }

    public Map<String, SubType> filterSubTypes(Map<String, SubType> allowedSubTypes) {
        if (this.denyAllTypes()) {
            return Collections.emptyMap();
        }
        List<String> allowedTypes = this.getAllowedTypes();
        List<String> deniedTypes = this.getDeniedTypes();
        if (allowedTypes.isEmpty() && deniedTypes.isEmpty()) {
            return allowedSubTypes;
        }
        HashMap<String, SubType> filteredAllowedSubTypes = new HashMap<String, SubType>(allowedSubTypes);
        Iterator it = filteredAllowedSubTypes.keySet().iterator();
        while (it.hasNext()) {
            String subTypeName = (String)it.next();
            if (!deniedTypes.contains(subTypeName) && (allowedTypes.isEmpty() || allowedTypes.contains(subTypeName))) continue;
            it.remove();
        }
        return filteredAllowedSubTypes;
    }

    public String getDefaultType() {
        return this.defaultType;
    }
}

