/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.mongodb.MongoWriteException;
import com.novemberain.quartz.mongodb.dao.LocksDao;
import com.novemberain.quartz.mongodb.util.ExpiryCalculator;
import org.bson.Document;
import org.quartz.JobDetail;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final Logger log = LoggerFactory.getLogger(LockManager.class);
    private LocksDao locksDao;
    private ExpiryCalculator expiryCalculator;

    public LockManager(LocksDao locksDao, ExpiryCalculator expiryCalculator) {
        this.locksDao = locksDao;
        this.expiryCalculator = expiryCalculator;
    }

    public void lockJob(JobDetail job) {
        if (job.isConcurrentExectionDisallowed()) {
            this.locksDao.lockJob(job);
        }
    }

    public void unlockAcquiredTrigger(OperableTrigger trigger) {
        this.locksDao.unlockTrigger(trigger);
    }

    public void unlockExpired(JobDetail job) {
        Document existingLock = this.locksDao.findJobLock(job.getKey());
        if (existingLock != null && this.expiryCalculator.isJobLockExpired(existingLock)) {
            log.debug("Removing expired lock for job {}", (Object)job.getKey());
            this.locksDao.remove(existingLock);
        }
    }

    public boolean tryLock(TriggerKey key) {
        try {
            this.locksDao.lockTrigger(key);
            return true;
        }
        catch (MongoWriteException e) {
            log.info("Failed to lock trigger {}, reason: {}", (Object)key, (Object)e.getError());
            return false;
        }
    }

    public boolean relockExpired(TriggerKey key) {
        Document existingLock = this.locksDao.findTriggerLock(key);
        if (existingLock != null) {
            if (this.expiryCalculator.isTriggerLockExpired(existingLock)) {
                log.info("Trigger {} is expired - re-locking", (Object)key);
                return this.locksDao.relock(key, existingLock.getDate((Object)"time"));
            }
            log.info("Trigger {} hasn't expired yet. Lock time: {}", (Object)key, (Object)existingLock.getDate((Object)"time"));
        } else {
            log.warn("Error retrieving expired lock from the database. Maybe it was deleted");
        }
        return false;
    }
}

