/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.quartz.SchedulerConfigException;

public class MongoConnector {
    private MongoClient mongo;

    private MongoConnector() {
    }

    public void shutdown() {
        this.mongo.close();
    }

    public MongoDatabase selectDatabase(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public static MongoConnectorBuilder builder() {
        return new MongoConnectorBuilder();
    }

    public static class MongoConnectorBuilder {
        private MongoConnector connector = new MongoConnector();
        private MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        private String mongoUri;
        private String username;
        private String password;
        private String[] addresses;
        private String dbName;
        private String authDbName;
        private int writeTimeout;

        public MongoConnector build() throws SchedulerConfigException {
            this.connect();
            return this.connector;
        }

        public MongoConnectorBuilder withClient(MongoClient mongo) {
            this.connector.mongo = mongo;
            return this;
        }

        public MongoConnectorBuilder withUri(String mongoUri) {
            this.mongoUri = mongoUri;
            return this;
        }

        public MongoConnectorBuilder withCredentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public MongoConnectorBuilder withAddresses(String[] addresses) {
            this.addresses = addresses;
            return this;
        }

        private void connect() throws SchedulerConfigException {
            if (this.connector.mongo == null) {
                this.initializeMongo();
            } else if (this.mongoUri != null || this.username != null || this.password != null || this.addresses != null) {
                throw new SchedulerConfigException("Configure either a Mongo instance or MongoDB connection parameters.");
            }
        }

        private void initializeMongo() throws SchedulerConfigException {
            this.connector.mongo = this.connectToMongoDB();
            if (this.connector.mongo == null) {
                throw new SchedulerConfigException("Could not connect to MongoDB! Please check that quartz-mongodb configuration is correct.");
            }
            this.setWriteConcern();
        }

        private MongoClient connectToMongoDB() throws SchedulerConfigException {
            if (this.mongoUri == null && (this.addresses == null || this.addresses.length == 0)) {
                throw new SchedulerConfigException("At least one MongoDB address or a MongoDB URI must be specified .");
            }
            if (this.mongoUri != null) {
                return this.connectToMongoDB(this.mongoUri);
            }
            return this.createClient();
        }

        private MongoClient createClient() throws SchedulerConfigException {
            MongoClientOptions options = this.createOptions();
            List<MongoCredential> credentials = this.createCredentials();
            List<ServerAddress> serverAddresses = this.collectServerAddresses();
            try {
                return new MongoClient(serverAddresses, credentials, options);
            }
            catch (MongoException e) {
                throw new SchedulerConfigException("Could not connect to MongoDB", (Throwable)e);
            }
        }

        private MongoClientOptions createOptions() {
            return this.optionsBuilder.build();
        }

        private List<MongoCredential> createCredentials() {
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>(1);
            if (this.username != null) {
                if (this.authDbName != null) {
                    credentials.add(MongoCredential.createCredential((String)this.username, (String)this.authDbName, (char[])this.password.toCharArray()));
                } else {
                    credentials.add(MongoCredential.createCredential((String)this.username, (String)this.dbName, (char[])this.password.toCharArray()));
                }
            }
            return credentials;
        }

        private List<ServerAddress> collectServerAddresses() {
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
            for (String a : this.addresses) {
                serverAddresses.add(new ServerAddress(a));
            }
            return serverAddresses;
        }

        private MongoClient connectToMongoDB(String mongoUriAsString) throws SchedulerConfigException {
            try {
                return new MongoClient(new MongoClientURI(mongoUriAsString));
            }
            catch (MongoException e) {
                throw new SchedulerConfigException("MongoDB driver thrown an exception", (Throwable)e);
            }
        }

        private void setWriteConcern() {
            WriteConcern writeConcern = WriteConcern.MAJORITY.withWTimeout((long)this.writeTimeout, TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
            this.connector.mongo.setWriteConcern(writeConcern);
        }

        public MongoConnectorBuilder withAuthDatabaseName(String authDbName) {
            this.authDbName = authDbName;
            return this;
        }

        public MongoConnectorBuilder withDatabaseName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public MongoConnectorBuilder withMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
            if (maxConnectionsPerHost != null) {
                this.optionsBuilder.connectionsPerHost(maxConnectionsPerHost.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withConnectTimeoutMillis(Integer connectTimeoutMillis) {
            if (connectTimeoutMillis != null) {
                this.optionsBuilder.connectTimeout(connectTimeoutMillis.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSocketTimeoutMillis(Integer socketTimeoutMillis) {
            if (socketTimeoutMillis != null) {
                this.optionsBuilder.socketTimeout(socketTimeoutMillis.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSocketKeepAlive(Boolean socketKeepAlive) {
            if (socketKeepAlive != null) {
                this.optionsBuilder.socketKeepAlive(socketKeepAlive.booleanValue());
            }
            return this;
        }

        public MongoConnectorBuilder withThreadsAllowedToBlockForConnectionMultiplier(Integer threadsAllowedToBlockForConnectionMultiplier) {
            if (threadsAllowedToBlockForConnectionMultiplier != null) {
                this.optionsBuilder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSSL(Boolean enableSSL, Boolean sslInvalidHostNameAllowed) {
            if (enableSSL != null) {
                this.optionsBuilder.sslEnabled(enableSSL.booleanValue());
                if (sslInvalidHostNameAllowed != null) {
                    this.optionsBuilder.sslInvalidHostNameAllowed(sslInvalidHostNameAllowed.booleanValue());
                }
            }
            return this;
        }

        public MongoConnectorBuilder withWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }
    }
}

