/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.ecm.core.storage.sql.Invalidations;

public class RedisInvalidations {
    private String nodeId;
    private Invalidations invalidations;

    public RedisInvalidations(String nodeId, Invalidations invals) {
        assert (nodeId != null) : "nodeId required";
        assert (invals != null) : "invals required";
        this.nodeId = nodeId;
        this.invalidations = invals;
    }

    public RedisInvalidations(String receiverNodeId, String message) {
        assert (receiverNodeId != null) : "receiverNodeId required";
        if (message == null || !message.contains(":")) {
            throw new IllegalArgumentException("Invalid message: " + message);
        }
        String[] parts = message.split(":", 2);
        this.nodeId = parts[0];
        if (!receiverNodeId.equals(this.nodeId)) {
            this.invalidations = this.deserializeInvalidations(parts[1]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Invalidations deserializeInvalidations(String invalsStr) {
        ByteArrayInputStream bain = new ByteArrayInputStream(Base64.decodeBase64((String)invalsStr));
        try (ObjectInputStream in = new ObjectInputStream(bain);){
            Invalidations invalidations = (Invalidations)in.readObject();
            return invalidations;
        }
        catch (IOException | ClassNotFoundException cause) {
            throw new IllegalArgumentException("Cannot deserialize invalidations", cause);
        }
    }

    public Invalidations getInvalidations() {
        return this.invalidations;
    }

    public String serialize() throws IOException {
        return this.nodeId + ":" + this.serializeInvalidations(this.invalidations);
    }

    private String serializeInvalidations(Invalidations invals) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baout);
        out.writeObject(invals);
        out.flush();
        out.close();
        return Base64.encodeBase64String((byte[])baout.toByteArray());
    }

    public String toString() {
        if (this.invalidations == null) {
            return "RedisInvalidationsInvalidations(local, discarded)";
        }
        return "RedisInvalidationsInvalidations(fromNode=" + this.nodeId + ", " + this.invalidations.toString() + ")";
    }
}

