/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.pubsub.AbstractPubSubProvider;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.SafeEncoder;

public class RedisPubSubProvider
extends AbstractPubSubProvider {
    static final Log log = LogFactory.getLog(RedisPubSubProvider.class);
    public static final long TIMEOUT_SUBSCRIBE_SECONDS = 5L;
    protected Dispatcher dispatcher;
    protected Thread thread;

    public void initialize(Map<String, String> options, Map<String, List<BiConsumer<String, byte[]>>> subscribers) {
        super.initialize(options, subscribers);
        log.debug((Object)"Initializing");
        this.namespace = ((RedisAdmin)Framework.getService(RedisAdmin.class)).namespace(new String[0]);
        this.dispatcher = new Dispatcher(this.namespace + "*");
        this.thread = new Thread(this.dispatcher::run, "Nuxeo-PubSub-Redis");
        this.thread.setUncaughtExceptionHandler((t, e) -> log.error((Object)("Uncaught error on thread " + t.getName()), e));
        this.thread.setPriority(5);
        this.thread.setDaemon(true);
        this.thread.start();
        if (!this.dispatcher.awaitSubscribed(5L, TimeUnit.SECONDS)) {
            this.thread.interrupt();
            throw new NuxeoException("Failed to subscribe to Redis pubsub after 5s");
        }
        log.debug((Object)"Initialized");
    }

    public void close() {
        log.debug((Object)"Closing");
        if (this.dispatcher != null) {
            this.thread.interrupt();
            this.thread = null;
            this.dispatcher.close();
            this.dispatcher = null;
        }
        log.debug((Object)"Closed");
    }

    public void publish(String topic, byte[] message) {
        String channel = this.namespace + topic;
        byte[] bchannel = SafeEncoder.encode((String)channel);
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        if (redisExecutor != null) {
            redisExecutor.execute(jedis -> jedis.publish(bchannel, message));
        }
    }

    public class Dispatcher
    extends JedisPubSub {
        protected RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        protected final String pattern;
        protected final CountDownLatch subscribedLatch;
        protected volatile boolean stop;

        public Dispatcher(String pattern) {
            this.pattern = pattern;
            this.subscribedLatch = new CountDownLatch(1);
        }

        public boolean awaitSubscribed(long timeout, TimeUnit unit) {
            try {
                return this.subscribedLatch.await(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new NuxeoException((Throwable)e);
            }
        }

        public void run() {
            log.debug((Object)("Subscribing to: " + this.pattern));
            RedisExecutor redisExecutor = this.redisExecutor;
            this.redisExecutor = null;
            redisExecutor.psubscribe((JedisPubSub)this, new String[]{this.pattern});
        }

        public void close() {
            this.stop = true;
            RedisPubSubProvider.this.publish("", new byte[0]);
        }

        public void onPSubscribe(String pattern, int subscribedChannels) {
            this.subscribedLatch.countDown();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscribed to: " + pattern));
            }
        }

        public void onMessage(String channel, byte[] message) {
            if (message == null) {
                message = new byte[]{};
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Message received from channel: " + channel + " (" + message.length + " bytes)"));
            }
            String topic = channel.substring(RedisPubSubProvider.this.namespace.length());
            RedisPubSubProvider.this.localPublish(topic, message);
        }

        public void onPMessage(String pattern, String channel, byte[] message) {
            this.onMessage(channel, message);
        }

        public void proceed(Client client, String ... channels) {
            client.subscribe(channels);
            this.flush(client);
            this.processBinary(client);
        }

        public void proceedWithPatterns(Client client, String ... patterns) {
            client.psubscribe(patterns);
            this.flush(client);
            this.processBinary(client);
        }

        protected void flush(Client client) {
            try {
                Method m = Connection.class.getDeclaredMethod("flush", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)client, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }

        protected void processBinary(Client client) {
            byte[] btype;
            while (true) {
                byte[] bpattern;
                byte[] bchannel;
                List reply = client.getRawObjectMultiBulkReply();
                if (this.stop) {
                    return;
                }
                Object type = reply.get(0);
                if (!(type instanceof byte[])) {
                    throw new JedisException("Unknown message type: " + type);
                }
                btype = (byte[])type;
                if (Arrays.equals(Protocol.Keyword.MESSAGE.raw, btype)) {
                    bchannel = (byte[])reply.get(1);
                    byte[] bmesg = (byte[])reply.get(2);
                    this.onMessage(this.toString(bchannel), bmesg);
                    continue;
                }
                if (Arrays.equals(Protocol.Keyword.PMESSAGE.raw, btype)) {
                    bpattern = (byte[])reply.get(1);
                    byte[] bchannel2 = (byte[])reply.get(2);
                    byte[] bmesg = (byte[])reply.get(3);
                    this.onPMessage(this.toString(bpattern), this.toString(bchannel2), bmesg);
                    continue;
                }
                if (Arrays.equals(Protocol.Keyword.SUBSCRIBE.raw, btype)) {
                    bchannel = (byte[])reply.get(1);
                    this.onSubscribe(this.toString(bchannel), 0);
                    continue;
                }
                if (Arrays.equals(Protocol.Keyword.PSUBSCRIBE.raw, btype)) {
                    bpattern = (byte[])reply.get(1);
                    this.onPSubscribe(this.toString(bpattern), 0);
                    continue;
                }
                if (Arrays.equals(Protocol.Keyword.UNSUBSCRIBE.raw, btype)) {
                    bchannel = (byte[])reply.get(1);
                    this.onUnsubscribe(this.toString(bchannel), 0);
                    continue;
                }
                if (!Arrays.equals(Protocol.Keyword.PUNSUBSCRIBE.raw, btype)) break;
                bpattern = (byte[])reply.get(1);
                this.onPUnsubscribe(this.toString(bpattern), 0);
            }
            throw new JedisException("Unknown message: " + this.toString(btype));
        }

        protected String toString(byte[] bytes) {
            return bytes == null ? null : SafeEncoder.encode((byte[])bytes);
        }
    }
}

