/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat;

import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.FrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.NuxeoWebappLoader;
import org.nuxeo.runtime.tomcat.dev.DevFrameworkBootstrap;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;

public class NuxeoLauncher
implements LifecycleListener {
    static final Log log = LogFactory.getLog(NuxeoLauncher.class);
    protected boolean shared;
    protected String home = "nxserver";
    protected boolean automaticReload = true;
    protected FrameworkBootstrap bootstrap;

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public void setAutomaticReload(boolean value) {
        this.automaticReload = value;
    }

    public boolean getAutomaticReload() {
        return this.automaticReload;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Loader loader;
        Lifecycle lf = event.getLifecycle();
        if (lf instanceof Context && (loader = ((Context)lf).getLoader()) instanceof NuxeoWebappLoader) {
            this.handleEvent((NuxeoWebappLoader)loader, event);
        }
    }

    protected void handleEvent(NuxeoWebappLoader loader, LifecycleEvent event) {
        String type = event.getType();
        try {
            MutableClassLoader cl = (MutableClassLoader)loader.getClassLoader();
            boolean devMode = cl instanceof NuxeoDevWebappClassLoader;
            if ("configure_start".equals(type)) {
                File homeDir = this.resolveHomeDirectory(loader);
                if (devMode) {
                    this.bootstrap = new DevFrameworkBootstrap(cl, homeDir);
                    ((NuxeoDevWebappClassLoader)cl).setBootstrap((DevFrameworkBootstrap)this.bootstrap);
                } else {
                    this.bootstrap = new FrameworkBootstrap(cl, homeDir);
                }
                this.bootstrap.setHostName("Tomcat");
                this.bootstrap.setHostVersion(ServerInfo.getServerNumber());
                this.bootstrap.initialize();
            } else if ("start".equals(type)) {
                this.bootstrap.start(cl);
            } else if ("stop".equals(type)) {
                this.bootstrap.stop(cl);
            }
        }
        catch (IOException | ReflectiveOperationException | JMException e) {
            log.error((Object)("Failed to handle event: " + type), (Throwable)e);
        }
    }

    protected File resolveHomeDirectory(NuxeoWebappLoader loader) {
        String path;
        if (this.home.startsWith("/") || this.home.startsWith("\\") || this.home.contains(":/") || this.home.contains(":\\")) {
            path = this.home;
        } else if (this.home.startsWith("${catalina.base}")) {
            path = this.getTomcatHome() + this.home.substring("${catalina.base}".length());
        } else {
            try {
                File baseDir = loader.getBaseDir();
                return new File(baseDir, this.home);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
        return new File(path);
    }

    public String getTomcatHome() {
        String tomcatHome = System.getProperty("catalina.base");
        if (tomcatHome == null) {
            tomcatHome = System.getProperty("catalina.home");
        }
        return tomcatHome;
    }
}

