/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.time.FastDateFormat;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class UserProfileEnricher
extends AbstractJsonEnricher<NuxeoPrincipal> {
    public static final String NAME = "userprofile";
    private static final FastDateFormat FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String COMPATIBILITY_CONFIGURATION_PARAM = "nuxeo.userprofile.enricher.compatibility";
    @Inject
    protected SchemaManager schemaManager;
    @Inject
    protected UserProfileService userProfileService;
    @Inject
    protected ConfigurationService configurationService;
    @Inject
    protected DownloadService downloadService;

    public UserProfileEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, NuxeoPrincipal nuxeoPrincipal) throws IOException {
        try (RenderingContext.SessionWrapper sw = this.ctx.getSession(null);){
            DocumentModel up = this.userProfileService.getUserProfileDocument(nuxeoPrincipal.getName(), sw.getSession());
            jg.writeFieldName(NAME);
            if (up == null) {
                jg.writeNull();
                return;
            }
            jg.writeStartObject();
            if (this.configurationService.isBooleanPropertyTrue(COMPATIBILITY_CONFIGURATION_PARAM)) {
                this.writeCompatibilityUserProfile(jg, up);
            } else {
                this.writeUserProfile(jg, up);
            }
            jg.writeEndObject();
        }
    }

    protected void writeCompatibilityUserProfile(JsonGenerator jg, DocumentModel up) throws IOException {
        Serializable propertyValue = up.getPropertyValue("userprofile:birthdate");
        jg.writeStringField("birthdate", propertyValue == null ? null : FORMATTER.format(((GregorianCalendar)propertyValue).getTime()));
        jg.writeStringField("phonenumber", (String)((Object)up.getPropertyValue("userprofile:phonenumber")));
        Blob avatar = (Blob)up.getPropertyValue("userprofile:avatar");
        if (avatar != null) {
            String url = this.downloadService.getDownloadUrl(up, "userprofile:avatar", avatar.getFilename());
            jg.writeStringField("avatar", this.ctx.getBaseUrl() + url);
        } else {
            jg.writeNullField("avatar");
        }
    }

    protected void writeUserProfile(JsonGenerator jg, DocumentModel up) throws IOException {
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        Schema schema = this.schemaManager.getSchema(NAME);
        try (Closeable resource = this.ctx.wrap().with("document", (Object)up).open();){
            for (Field field : schema.getFields()) {
                jg.writeFieldName(field.getName().getLocalName());
                Property property = up.getProperty(field.getName().getPrefixedName());
                OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
            }
        }
    }
}

