/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.io.Externalizable;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.bulk.BulkActionValidation;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.stream.StreamService;

public class BulkServiceImpl
implements BulkService {
    private static final Logger log = LogManager.getLogger(BulkServiceImpl.class);
    public static final String BULK_LOG_MANAGER_NAME = "bulk";
    public static final String BULK_KV_STORE_NAME = "bulk";
    public static final String COMMAND_STREAM = "command";
    public static final String STATUS_STREAM = "status";
    public static final String DONE_STREAM = "done";
    public static final String RECORD_CODEC = "avro";
    public static final String COMMAND_PREFIX = "command:";
    public static final String STATUS_PREFIX = "status:";
    public static final String PRODUCE_IMMEDIATE_OPTION = "produceImmediate";
    public static final long COMPLETED_TTL_SECONDS = 3600L;
    public static final long ABORTED_TTL_SECONDS = 7200L;

    @Override
    public String submit(BulkCommand command) {
        log.debug("Run action with command={}", (Object)command);
        BulkAdminService adminService = (BulkAdminService)Framework.getService(BulkAdminService.class);
        if (!adminService.getActions().contains(command.getAction())) {
            throw new IllegalArgumentException("Unknown action for command: " + command);
        }
        BulkActionValidation actionValidation = adminService.getActionValidation(command.getAction());
        if (actionValidation != null) {
            actionValidation.validate(command);
        }
        RepositoryManager repoManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (StringUtils.isEmpty((CharSequence)command.getRepository())) {
            command.setRepository(repoManager.getDefaultRepositoryName());
        } else if (repoManager.getRepository(command.getRepository()) == null) {
            throw new IllegalArgumentException("Unknown repository: " + command);
        }
        if (command.getBucketSize() == 0 || command.getBatchSize() == 0) {
            if (command.getBucketSize() == 0) {
                command.setBucketSize(adminService.getBucketSize(command.getAction()));
            }
            if (command.getBatchSize() == 0) {
                command.setBatchSize(adminService.getBatchSize(command.getAction()));
            }
        }
        BulkStatus status = new BulkStatus(command.getId());
        status.setState(BulkStatus.State.SCHEDULED);
        status.setAction(command.getAction());
        status.setUsername(command.getUsername());
        status.setSubmitTime(Instant.now());
        this.setStatus(status);
        byte[] commandAsBytes = this.setCommand(command);
        String shardKey = adminService.isSequentialCommands(command.getAction()) ? command.getAction() : command.getId();
        org.nuxeo.lib.stream.log.LogManager logManager = ((StreamService)Framework.getService(StreamService.class)).getLogManager("bulk");
        LogAppender logAppender = logManager.getAppender(COMMAND_STREAM, ((CodecService)Framework.getService(CodecService.class)).getCodec(RECORD_CODEC, Record.class));
        logAppender.append(shardKey, (Externalizable)Record.of((String)command.getId(), (byte[])commandAsBytes));
        return command.getId();
    }

    public BulkStatus getStatus(String commandId) {
        KeyValueStore keyValueStore = this.getKvStore();
        byte[] statusAsBytes = keyValueStore.get(STATUS_PREFIX + commandId);
        if (statusAsBytes == null) {
            log.debug("Request status of unknown command: {}", (Object)commandId);
            return BulkStatus.unknownOf(commandId);
        }
        return (BulkStatus)BulkCodecs.getStatusCodec().decode(statusAsBytes);
    }

    public byte[] setStatus(BulkStatus status) {
        KeyValueStore kvStore = this.getKvStore();
        byte[] statusAsBytes = BulkCodecs.getStatusCodec().encode((Object)status);
        switch (status.getState()) {
            case ABORTED: {
                kvStore.put(STATUS_PREFIX + status.getId(), statusAsBytes, 7200L);
                kvStore.put(COMMAND_PREFIX + status.getId(), (String)null);
                break;
            }
            case COMPLETED: {
                kvStore.put(STATUS_PREFIX + status.getId(), statusAsBytes, 3600L);
                kvStore.setTTL(COMMAND_PREFIX + status.getId(), 3600L);
                break;
            }
            default: {
                kvStore.put(STATUS_PREFIX + status.getId(), statusAsBytes);
            }
        }
        return statusAsBytes;
    }

    @Override
    public BulkCommand getCommand(String commandId) {
        KeyValueStore keyValueStore = this.getKvStore();
        byte[] statusAsBytes = keyValueStore.get(COMMAND_PREFIX + commandId);
        if (statusAsBytes == null) {
            return null;
        }
        return (BulkCommand)BulkCodecs.getCommandCodec().decode(statusAsBytes);
    }

    public BulkStatus abort(String commandId) {
        BulkStatus status = this.getStatus(commandId);
        if (BulkStatus.State.COMPLETED.equals((Object)status.getState())) {
            log.debug("Cannot abort a completed command: {}", (Object)commandId);
            return status;
        }
        status.setState(BulkStatus.State.ABORTED);
        this.setStatus(status);
        BulkStatus delta = BulkStatus.deltaOf(commandId);
        delta.setCompletedTime(Instant.now());
        delta.setState(BulkStatus.State.ABORTED);
        byte[] statusAsBytes = BulkCodecs.getStatusCodec().encode((Object)delta);
        org.nuxeo.lib.stream.log.LogManager logManager = ((StreamService)Framework.getService(StreamService.class)).getLogManager("bulk");
        LogAppender logAppender = logManager.getAppender(STATUS_STREAM);
        logAppender.append(commandId, (Externalizable)Record.of((String)commandId, (byte[])statusAsBytes));
        return status;
    }

    public Map<String, Serializable> getResult(String commandId) {
        return this.getStatus(commandId).getResult();
    }

    public byte[] setCommand(BulkCommand command) {
        KeyValueStore kvStore = this.getKvStore();
        byte[] commandAsBytes = BulkCodecs.getCommandCodec().encode((Object)command);
        kvStore.put(COMMAND_PREFIX + command.getId(), commandAsBytes);
        return commandAsBytes;
    }

    @Override
    public boolean await(String commandId, Duration duration) throws InterruptedException {
        long deadline = System.currentTimeMillis() + duration.toMillis();
        do {
            BulkStatus status = this.getStatus(commandId);
            switch (status.getState()) {
                case ABORTED: 
                case COMPLETED: {
                    return true;
                }
                case UNKNOWN: {
                    log.error("Unknown status for command: {}", (Object)commandId);
                    return false;
                }
            }
            Thread.sleep(100L);
        } while (deadline > System.currentTimeMillis());
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> this.getStatus(commandId);
        supplierArray[1] = duration::toMillis;
        log.debug("await timeout on {} after {} ms", supplierArray);
        return false;
    }

    public KeyValueStore getKvStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore("bulk");
    }

    @Override
    public boolean await(Duration duration) throws InterruptedException {
        KeyValueStoreProvider kv = (KeyValueStoreProvider)this.getKvStore();
        Set commandIds = kv.keyStream(STATUS_PREFIX).map(k -> k.replaceFirst(STATUS_PREFIX, "")).collect(Collectors.toSet());
        long deadline = System.nanoTime() + duration.toNanos();
        for (String commandId : commandIds) {
            BulkStatus status;
            BulkStatus.State state;
            while ((state = (status = this.getStatus(commandId)).getState()) != BulkStatus.State.COMPLETED && state != BulkStatus.State.ABORTED && state != BulkStatus.State.UNKNOWN) {
                Thread.sleep(200L);
                if (deadline >= System.nanoTime()) continue;
                log.debug("await timeout, at least one uncompleted command: {}", (Object)status);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<BulkStatus> getStatuses(String username) {
        KeyValueStoreProvider kv = (KeyValueStoreProvider)this.getKvStore();
        return kv.keyStream(STATUS_PREFIX).map(arg_0 -> ((KeyValueStoreProvider)kv).get(arg_0)).map(arg_0 -> BulkCodecs.getStatusCodec().decode(arg_0)).filter(status -> username.equals(status.getUsername())).collect(Collectors.toList());
    }
}

