/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class SetSystemPropertiesAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "setSystemProperties";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(SetSystemPropertyComputation::new, Arrays.asList("i1:setSystemProperties", "o1:status")).build();
    }

    public static class SetSystemPropertyComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(SetSystemPropertyComputation.class);

        public SetSystemPropertyComputation() {
            super(SetSystemPropertiesAction.ACTION_NAME);
        }

        @Override
        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            Collection refs = ids.stream().map(IdRef::new).collect(Collectors.toList());
            for (DocumentRef ref : refs) {
                for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                    try {
                        session.setDocumentSystemProp(ref, entry.getKey(), entry.getValue());
                    }
                    catch (NuxeoException e) {
                        log.warn("Cannot set system property: " + entry.getKey() + " on: " + ref.toString(), (Throwable)e);
                    }
                }
            }
            try {
                session.save();
            }
            catch (PropertyException e) {
                log.warn("Cannot save session", (Throwable)e);
            }
        }
    }
}

