/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheInvalidator;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheMetrics;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableMessage;

public class CacheServiceImpl
extends DefaultComponent
implements CacheService {
    private static final Logger log = LogManager.getLogger(CacheServiceImpl.class);
    public static final String XP_CACHES = "caches";
    protected static final Random RANDOM = new Random();
    public static final String DEFAULT_CACHE_ID = "default-cache";
    public static final String CACHE_INVAL_PUBSUB_TOPIC = "cacheinval";
    public static final String CLUSTERING_ENABLED_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_PROP = "repository.clustering.id";
    protected boolean started;
    protected final Map<String, CacheManagement> caches = new ConcurrentHashMap<String, CacheManagement>();
    protected CachePubSubInvalidator invalidator;

    @Override
    @Deprecated
    public void registerCache(String name, int maxSize, int timeout) {
        this.registerCache(name);
    }

    @Override
    public void registerCache(String name) {
        CacheDescriptor defaultDescriptor = this.getCacheDescriptor(DEFAULT_CACHE_ID);
        if (defaultDescriptor == null) {
            defaultDescriptor = new CacheDescriptor();
            defaultDescriptor.name = DEFAULT_CACHE_ID;
            defaultDescriptor.options.put("maxSize", String.valueOf(100L));
            this.register(XP_CACHES, defaultDescriptor);
        }
        CacheDescriptor newDescriptor = (CacheDescriptor)new CacheDescriptor().merge(defaultDescriptor);
        newDescriptor.name = name;
        this.register(XP_CACHES, newDescriptor);
        this.maybeStart(name);
    }

    public int getApplicationStartedOrder() {
        ComponentInstance repositoryComponent = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        if (repositoryComponent == null || repositoryComponent.getInstance() == null) {
            return super.getApplicationStartedOrder();
        }
        return ((DefaultComponent)repositoryComponent.getInstance()).getApplicationStartedOrder() - 5;
    }

    public void start(ComponentContext context) {
        super.start(context);
        if (Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_PROP)) {
            String nodeId = Framework.getProperty((String)NODE_ID_PROP);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                nodeId = String.valueOf(RANDOM.nextLong());
                log.warn("Missing cluster node id configuration, please define it explicitly (usually through repository.clustering.id). Using random cluster node id instead: {}", (Object)nodeId);
            } else {
                nodeId = nodeId.trim();
            }
            this.invalidator = new CachePubSubInvalidator();
            this.invalidator.initialize(CACHE_INVAL_PUBSUB_TOPIC, nodeId);
            log.info("Registered cache invalidator for node: {}", (Object)nodeId);
        } else {
            log.info("Not registering a cache invalidator because clustering is not enabled");
        }
        List descriptors = this.getDescriptors(XP_CACHES);
        descriptors.forEach(this::startCacheDescriptor);
        this.started = true;
    }

    protected void startCacheDescriptor(CacheDescriptor desc) {
        CacheManagement cache;
        if (desc.klass == null) {
            cache = new InMemoryCacheImpl(desc);
        } else {
            try {
                cache = desc.klass.getConstructor(CacheDescriptor.class).newInstance(desc);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to instantiate class: " + desc.klass + " for cache: " + desc.name, (Throwable)e);
            }
        }
        cache = new CacheAttributesChecker(cache);
        cache = new CacheMetrics(cache);
        if (this.invalidator != null) {
            cache = new CacheInvalidator(cache, this.invalidator);
        }
        cache.start();
        this.caches.put(desc.name, cache);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        if (this.invalidator != null) {
            this.invalidator.close();
            this.invalidator = null;
        }
        for (CacheManagement cache : this.caches.values()) {
            cache.stop();
        }
        this.caches.clear();
        this.started = false;
    }

    protected void maybeStart(String name) {
        if (!this.started) {
            return;
        }
        CacheManagement cache = this.caches.get(name);
        if (cache != null) {
            cache.stop();
        }
        this.startCacheDescriptor(this.getCacheDescriptor(name));
    }

    @Override
    public Cache getCache(String name) {
        return this.caches.get(name);
    }

    public CacheDescriptor getCacheDescriptor(String descriptor) {
        return (CacheDescriptor)this.getDescriptor(XP_CACHES, descriptor);
    }

    protected class CachePubSubInvalidator
    extends AbstractCachePubSubInvalidator {
        protected CachePubSubInvalidator() {
        }

        @Override
        protected Cache getCache(String name) {
            return CacheServiceImpl.this.getCache(name);
        }
    }

    public static abstract class AbstractCachePubSubInvalidator
    extends AbstractPubSubBroker<CacheInvalidation> {
        public static final String ALL_KEYS = "__ALL__";

        public CacheInvalidation deserialize(InputStream in) throws IOException {
            return CacheInvalidation.deserialize(in);
        }

        public void sendInvalidation(String cacheName, String key) {
            this.sendMessage(new CacheInvalidation(cacheName, key));
        }

        public void sendInvalidationsAll(String cacheName) {
            this.sendMessage(new CacheInvalidation(cacheName, ALL_KEYS));
        }

        public void receivedMessage(CacheInvalidation invalidation) {
            CacheManagement cache = (CacheManagement)this.getCache(invalidation.cacheName);
            if (cache != null) {
                String key = invalidation.key;
                if (ALL_KEYS.equals(key)) {
                    cache.invalidateLocalAll();
                } else {
                    cache.invalidateLocal(key);
                }
            }
        }

        protected abstract Cache getCache(String var1);
    }

    public static class CacheInvalidation
    implements SerializableMessage {
        private static final long serialVersionUID = 1L;
        protected static final String SEP = "/";
        public final String cacheName;
        public final String key;

        public CacheInvalidation(String name, String key) {
            this.cacheName = name;
            this.key = key;
        }

        public void serialize(OutputStream out) throws IOException {
            String string = this.cacheName + SEP + this.key;
            IOUtils.write((String)string, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }

        public static CacheInvalidation deserialize(InputStream in) throws IOException {
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            String[] parts = string.split(SEP, 2);
            if (parts.length != 2) {
                throw new IOException("Invalid invalidation: " + string);
            }
            String cacheName = parts[0];
            String key = parts[1];
            return new CacheInvalidation(cacheName, key);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.cacheName + "," + this.key + ")";
        }
    }
}

