/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore.keyvalueblob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.transientstore.api.MaximumTransientSpaceExceeded;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;

public class KeyValueBlobTransientStore
implements TransientStoreProvider {
    private static final Log log = LogFactory.getLog(KeyValueBlobTransientStore.class);
    public static final String SEP = ".";
    public static final String STORAGE_SIZE = "__blobsize__";
    public static final String DOT_COMPLETED = ".completed";
    public static final String DOT_PARAMINFO = ".paraminfo";
    public static final String DOT_PARAM_DOT = ".param.";
    public static final String FORMAT = "__format";
    public static final String FORMAT_JAVA = "java";
    public static final String DOT_BLOBINFO = ".blobinfo";
    public static final String COUNT = "count";
    public static final String SIZE = "size";
    public static final String DOT_BLOB_DOT = ".blob.";
    public static final String KEY = "key";
    public static final String MIMETYPE = "mimetype";
    public static final String ENCODING = "encoding";
    public static final String FILENAME = "filename";
    public static final String LENGTH = "length";
    public static final String DIGEST = "digest";
    public static final String CONFIG_KEY_VALUE_STORE = "keyValueStore";
    public static final String CONFIG_BLOB_PROVIDER = "blobProvider";
    public static final String CONFIG_DEFAULT_BLOB_PROVIDER = "defaultBlobProvider";
    public static final String CONFIG_DEFAULT_BLOB_PROVIDER_DEFAULT = "default";
    protected String keyValueStoreName;
    protected String blobProviderId;
    protected String defaultBlobProviderId;
    protected int ttl;
    protected int releaseTTL;
    protected long targetMaxSize;
    protected long absoluteMaxSize;
    protected ObjectMapper mapper;
    protected static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    protected static final TypeReference<Map<String, String>> MAP_STRING_STRING = new TypeReference<Map<String, String>>(){};

    @Override
    public void init(TransientStoreConfig config) {
        Map<String, String> properties;
        String defaultName = config.getName();
        if (!defaultName.startsWith("transient")) {
            defaultName = "transient_" + defaultName;
        }
        if ((properties = config.getProperties()) == null) {
            properties = Collections.emptyMap();
        }
        this.keyValueStoreName = (String)StringUtils.defaultIfBlank((CharSequence)properties.get(CONFIG_KEY_VALUE_STORE), (CharSequence)defaultName);
        this.blobProviderId = (String)StringUtils.defaultIfBlank((CharSequence)properties.get(CONFIG_BLOB_PROVIDER), (CharSequence)defaultName);
        this.defaultBlobProviderId = (String)StringUtils.defaultIfBlank((CharSequence)properties.get(CONFIG_DEFAULT_BLOB_PROVIDER), (CharSequence)CONFIG_DEFAULT_BLOB_PROVIDER_DEFAULT);
        this.mapper = new ObjectMapper();
        this.ttl = config.getFirstLevelTTL() * 60;
        this.releaseTTL = config.getSecondLevelTTL() * 60;
        this.targetMaxSize = (long)config.getTargetMaxSizeMB() * 1024L * 1024L;
        this.absoluteMaxSize = (long)config.getAbsoluteMaxSizeMB() * 1024L * 1024L;
    }

    protected KeyValueStore getKeyValueStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(this.keyValueStoreName);
    }

    protected BlobProvider getBlobProvider() {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProviderWithNamespace(this.blobProviderId, this.defaultBlobProviderId);
        if (blobProvider == null) {
            throw new NuxeoException("No blob provider with id: " + this.blobProviderId);
        }
        if (!blobProvider.isTransient()) {
            throw new NuxeoException("Blob provider: " + this.blobProviderId + " used for Key/Value store: " + this.keyValueStoreName + " must be configured as transient");
        }
        return blobProvider;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Stream<String> keyStream() {
        KeyValueStoreProvider kvs = (KeyValueStoreProvider)this.getKeyValueStore();
        int len = DOT_COMPLETED.length();
        return kvs.keyStream().filter(key -> key.endsWith(DOT_COMPLETED)).map(key -> key.substring(0, key.length() - len));
    }

    @Override
    public long getStorageSize() {
        KeyValueStore kvs = this.getKeyValueStore();
        String sizeStr = kvs.getString(STORAGE_SIZE);
        return sizeStr == null ? 0L : Long.parseLong(sizeStr);
    }

    protected void addStorageSize(long delta) {
        this.atomicUpdate(STORAGE_SIZE, size -> {
            long s = size == null ? 0L : Long.parseLong(size);
            return String.valueOf(s + delta);
        }, 0L);
    }

    protected void computeStorageSize() {
        KeyValueStore kvs = this.getKeyValueStore();
        long size = this.keyStream().map(this::getBlobs).flatMap(Collection::stream).mapToLong(Blob::getLength).sum();
        kvs.put(STORAGE_SIZE, String.valueOf(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGC() {
        BlobProvider bp = this.getBlobProvider();
        BinaryGarbageCollector gc = bp.getBinaryManager().getGarbageCollector();
        boolean delete = false;
        gc.start();
        try {
            this.keyStream().map(this::getBlobKeys).flatMap(Collection::stream).forEach(arg_0 -> ((BinaryGarbageCollector)gc).mark(arg_0));
            delete = true;
        }
        finally {
            gc.stop(delete);
        }
        this.computeStorageSize();
    }

    @Override
    public void removeAll() {
        KeyValueStoreProvider kvs = (KeyValueStoreProvider)this.getKeyValueStore();
        kvs.clear();
        this.doGC();
    }

    protected List<String> jsonToList(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (List)this.mapper.readValue(json, LIST_STRING);
        }
        catch (IOException e) {
            log.error((Object)("Invalid JSON array: " + json));
            return null;
        }
    }

    protected Map<String, String> jsonToMap(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (Map)this.mapper.readValue(json, MAP_STRING_STRING);
        }
        catch (IOException e) {
            log.error((Object)("Invalid JSON object: " + json));
            return null;
        }
    }

    protected String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public void atomicUpdate(String key, Function<String, String> updateFunction, long ttl) {
        String newValue;
        String oldValue;
        KeyValueStore kvs = this.getKeyValueStore();
        while (!kvs.compareAndSet(key, oldValue = kvs.getString(key), newValue = updateFunction.apply(oldValue), ttl)) {
        }
    }

    @Override
    public boolean exists(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        return kvs.getString(key + DOT_COMPLETED) != null;
    }

    protected void markEntryExists(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        kvs.compareAndSet(key + DOT_COMPLETED, null, "false", (long)this.ttl);
    }

    @Override
    public void putParameter(String key, String parameter, Serializable value) {
        KeyValueStore kvs = this.getKeyValueStore();
        String k = key + DOT_PARAM_DOT + parameter;
        if (value instanceof String) {
            kvs.put(k, (String)((Object)value), (long)this.ttl);
            kvs.put(k + FORMAT, (String)null);
        } else {
            byte[] bytes = SerializationUtils.serialize((Serializable)value);
            kvs.put(k, bytes, (long)this.ttl);
            kvs.put(k + FORMAT, FORMAT_JAVA, (long)this.ttl);
        }
        this.atomicUpdate(key + DOT_PARAMINFO, json -> {
            List<String> parameters = this.jsonToList((String)json);
            if (parameters == null) {
                parameters = new ArrayList<String>();
            }
            if (!parameters.contains(parameter)) {
                parameters.add(parameter);
            }
            return this.toJson(parameters);
        }, this.ttl);
        this.markEntryExists(key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Serializable getParameter(String key, String parameter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void putParameters(String key, Map<String, Serializable> parameters) {
        parameters.forEach((param, value) -> this.putParameter(key, (String)param, (Serializable)value));
    }

    @Override
    public Map<String, Serializable> getParameters(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        String json = kvs.getString(key + DOT_PARAMINFO);
        List<String> parameters = this.jsonToList(json);
        if (parameters == null) {
            if (kvs.getString(key + DOT_COMPLETED) == null) {
                return null;
            }
            return Collections.emptyMap();
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String p : parameters) {
            Serializable value = this.getParameter(key, p);
            if (value == null) continue;
            map.put(p, value);
        }
        return map;
    }

    protected void removeParameters(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        String json = kvs.getString(key + DOT_PARAMINFO);
        List<String> parameters = this.jsonToList(json);
        if (parameters != null) {
            for (String parameter : parameters) {
                String k = key + DOT_PARAM_DOT + parameter;
                kvs.put(k, (String)null);
                kvs.put(k + FORMAT, (String)null);
            }
        }
        kvs.put(key + DOT_PARAMINFO, (String)null);
    }

    @Override
    public void putBlobs(String key, List<Blob> blobs) {
        if (this.absoluteMaxSize > 0L && this.getStorageSize() > this.absoluteMaxSize) {
            this.doGC();
            if (this.getStorageSize() > this.absoluteMaxSize) {
                throw new MaximumTransientSpaceExceeded();
            }
        }
        this.removeBlobs(key);
        KeyValueStore kvs = this.getKeyValueStore();
        BlobProvider bp = this.getBlobProvider();
        long totalSize = 0L;
        int i = 0;
        for (Blob blob : blobs) {
            String blobKey;
            long size = blob.getLength();
            if (size >= 0L) {
                totalSize += size;
            }
            try {
                blobKey = bp.writeBlob(blob);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            HashMap<String, String> blobMap = new HashMap<String, String>();
            blobMap.put(KEY, blobKey);
            blobMap.put(MIMETYPE, blob.getMimeType());
            blobMap.put(ENCODING, blob.getEncoding());
            blobMap.put(FILENAME, blob.getFilename());
            blobMap.put(LENGTH, String.valueOf(size));
            blobMap.put(DIGEST, blob.getDigest());
            kvs.put(key + DOT_BLOB_DOT + i, this.toJson(blobMap), (long)this.ttl);
            ++i;
        }
        HashMap<String, String> blobInfoMap = new HashMap<String, String>();
        blobInfoMap.put(COUNT, String.valueOf(blobs.size()));
        blobInfoMap.put(SIZE, String.valueOf(totalSize));
        kvs.put(key + DOT_BLOBINFO, this.toJson(blobInfoMap), (long)this.ttl);
        this.addStorageSize(totalSize);
        this.markEntryExists(key);
    }

    protected void removeBlobs(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        String json = kvs.getString(key + DOT_BLOBINFO);
        Map<String, String> map = this.jsonToMap(json);
        if (map == null) {
            return;
        }
        String countStr = map.get(COUNT);
        int count = countStr == null ? 0 : Integer.parseInt(countStr);
        String sizeStr = map.get(SIZE);
        long size = sizeStr == null ? 0L : Long.parseLong(sizeStr);
        for (int i = 0; i < count; ++i) {
            kvs.put(key + DOT_BLOB_DOT + i, (String)null);
        }
        kvs.put(key + DOT_BLOBINFO, (String)null);
        this.addStorageSize(-size);
    }

    @Override
    public List<Blob> getBlobs(String key) {
        Map<String, String> blobMap;
        String blobKey;
        String blobMapJson;
        KeyValueStore kvs = this.getKeyValueStore();
        BlobProvider bp = this.getBlobProvider();
        String info = kvs.getString(key + DOT_BLOBINFO);
        if (info == null) {
            if (kvs.getString(key + DOT_COMPLETED) == null) {
                return null;
            }
            return Collections.emptyList();
        }
        Map<String, String> blobInfoMap = this.jsonToMap(info);
        String countStr = blobInfoMap.get(COUNT);
        if (countStr == null) {
            return Collections.emptyList();
        }
        int count = Integer.parseInt(countStr);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (int i = 0; i < count && (blobMapJson = kvs.getString(key + DOT_BLOB_DOT + i)) != null && (blobKey = (blobMap = this.jsonToMap(blobMapJson)).get(KEY)) != null; ++i) {
            String mimeType = blobMap.get(MIMETYPE);
            String encoding = blobMap.get(ENCODING);
            String filename = blobMap.get(FILENAME);
            String lengthStr = blobMap.get(LENGTH);
            Long length = lengthStr == null ? null : Long.valueOf(lengthStr);
            String digest = blobMap.get(DIGEST);
            BlobInfo blobInfo = new BlobInfo();
            blobInfo.key = blobKey;
            blobInfo.mimeType = mimeType;
            blobInfo.encoding = encoding;
            blobInfo.filename = filename;
            blobInfo.length = length;
            blobInfo.digest = digest;
            try {
                Blob blob = bp.readBlob(blobInfo);
                blobs.add(blob);
                continue;
            }
            catch (IOException e) {
                log.debug((Object)("Failed to read blob: " + digest));
            }
        }
        return blobs;
    }

    protected List<String> getBlobKeys(String key) {
        Map<String, String> blobMap;
        String blobKey;
        String blobMapJson;
        KeyValueStore kvs = this.getKeyValueStore();
        String info = kvs.getString(key + DOT_BLOBINFO);
        if (info == null) {
            return Collections.emptyList();
        }
        Map<String, String> blobInfoMap = this.jsonToMap(info);
        String countStr = blobInfoMap.get(COUNT);
        if (countStr == null) {
            return Collections.emptyList();
        }
        int count = Integer.parseInt(countStr);
        ArrayList<String> blobKeys = new ArrayList<String>(count);
        for (int i = 0; i < count && (blobMapJson = kvs.getString(key + DOT_BLOB_DOT + i)) != null && (blobKey = (blobMap = this.jsonToMap(blobMapJson)).get(KEY)) != null; ++i) {
            blobKeys.add(blobKey);
        }
        return blobKeys;
    }

    @Override
    public long getSize(String key) {
        String size;
        KeyValueStore kvs = this.getKeyValueStore();
        String json = kvs.getString(key + DOT_BLOBINFO);
        Map<String, String> map = this.jsonToMap(json);
        if (map == null || (size = map.get(SIZE)) == null) {
            return -1L;
        }
        return Long.parseLong(size);
    }

    @Override
    public boolean isCompleted(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        String completed = kvs.getString(key + DOT_COMPLETED);
        return Boolean.parseBoolean(completed);
    }

    @Override
    public void setCompleted(String key, boolean completed) {
        KeyValueStore kvs = this.getKeyValueStore();
        kvs.put(key + DOT_COMPLETED, String.valueOf(completed), (long)this.ttl);
    }

    protected void removeCompleted(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        kvs.put(key + DOT_COMPLETED, (String)null);
    }

    @Override
    public void release(String key) {
        if (this.targetMaxSize > 0L && this.getStorageSize() > this.targetMaxSize) {
            this.doGC();
            if (this.getStorageSize() > this.targetMaxSize) {
                this.remove(key);
                return;
            }
        }
        this.setReleaseTTL(key);
    }

    protected void setReleaseTTL(String key) {
        KeyValueStore kvs = this.getKeyValueStore();
        kvs.setTTL(key + DOT_COMPLETED, (long)this.releaseTTL);
        String json = kvs.getString(key + DOT_PARAMINFO);
        List<String> parameters = this.jsonToList(json);
        if (parameters != null) {
            parameters.stream().forEach(parameter -> {
                String k = key + DOT_PARAM_DOT + parameter;
                kvs.setTTL(k, (long)this.releaseTTL);
                kvs.setTTL(k + FORMAT, (long)this.releaseTTL);
            });
        }
        kvs.setTTL(key + DOT_PARAMINFO, (long)this.releaseTTL);
        json = kvs.getString(key + DOT_BLOBINFO);
        Map<String, String> map = this.jsonToMap(json);
        if (map != null) {
            String countStr = map.get(COUNT);
            int count = countStr == null ? 0 : Integer.parseInt(countStr);
            for (int i = 0; i < count; ++i) {
                kvs.setTTL(key + DOT_BLOB_DOT + i, (long)this.releaseTTL);
            }
        }
        kvs.setTTL(key + DOT_BLOBINFO, (long)this.releaseTTL);
    }

    @Override
    public void remove(String key) {
        this.removeBlobs(key);
        this.removeParameters(key);
        this.removeCompleted(key);
    }
}

