/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.runtime.api.Framework;

public class JSONBatchBlobDecoder
implements JSONBlobDecoder {
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        Blob blob = null;
        if (!jsonObject.has("upload-batch")) {
            return null;
        }
        String batchId = jsonObject.get("upload-batch").textValue();
        String fileId = null;
        if (jsonObject.has("upload-fileId")) {
            fileId = jsonObject.get("upload-fileId").textValue();
        }
        if (fileId != null) {
            BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
            Batch batch = bm.getBatch(batchId);
            if (batch == null) {
                return null;
            }
            blob = batch.getBlob(fileId);
            if (RequestContext.getActiveContext() != null) {
                boolean drop;
                boolean bl = drop = !Boolean.parseBoolean(RequestContext.getActiveContext().getRequest().getHeader("X-Batch-No-Drop"));
                if (drop) {
                    RequestContext.getActiveContext().addRequestCleanupHandler(request -> {
                        BatchManager bm1 = (BatchManager)Framework.getService(BatchManager.class);
                        bm1.clean(batchId);
                    });
                }
            }
        }
        return blob;
    }
}

