/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.pubsub;

import java.io.Externalizable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.pubsub.AbstractPubSubProvider;
import org.nuxeo.runtime.stream.StreamService;

public class StreamPubSubProvider
extends AbstractPubSubProvider {
    private static final Log log = LogFactory.getLog(StreamPubSubProvider.class);
    public static final String GROUP_PREFIX = "pub-sub-node-";
    protected static final String NODE_ID_PROP = "repository.clustering.id";
    protected static final String LOG_CONFIG_OPT = "logConfig";
    protected static final String DEFAULT_LOG_CONFIG = "default";
    protected static final String LOG_NAME_OPT = "logName";
    protected static final String CODEC_OPT = "codec";
    protected static final String DEFAULT_CODEC = "avroBinary";
    protected static final Random RANDOM = new Random();
    protected String logConfig;
    protected String logName;
    protected LogAppender<Record> appender;
    protected Thread thread;
    protected Codec<Record> codec;

    @Override
    public void initialize(Map<String, String> options, Map<String, List<BiConsumer<String, byte[]>>> subscribers) {
        log.debug((Object)"Initializing ");
        super.initialize(options, subscribers);
        this.logConfig = options.getOrDefault(LOG_CONFIG_OPT, DEFAULT_LOG_CONFIG);
        this.logName = options.get(LOG_NAME_OPT);
        if (StringUtils.isBlank((CharSequence)this.logName)) {
            throw new IllegalArgumentException("Missing option logName in StreamPubSubProviderDescriptor");
        }
        String codecName = options.getOrDefault(CODEC_OPT, DEFAULT_CODEC);
        CodecService codecService = (CodecService)Framework.getService(CodecService.class);
        this.codec = codecService.getCodec(codecName, Record.class);
        this.appender = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig).getAppender(this.logName, this.codec);
        this.startConsumerThread();
        log.debug((Object)"Initialized");
    }

    protected void startConsumerThread() {
        Subscriber subscriber = new Subscriber();
        this.thread = new Thread((Runnable)subscriber, "Nuxeo-PubSub-Stream");
        this.thread.setUncaughtExceptionHandler((t, e) -> log.error((Object)("Uncaught error on thread " + t.getName()), e));
        this.thread.setPriority(5);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void publish(String topic, byte[] message) {
        this.appender.append(topic, (Externalizable)Record.of((String)topic, (byte[])message));
    }

    @Override
    public void close() {
        this.appender = null;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
            log.debug((Object)"Closed");
        }
    }

    protected String getNodeId() {
        String nodeId = Framework.getProperty((String)NODE_ID_PROP);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return String.valueOf(RANDOM.nextLong());
        }
        return nodeId.trim();
    }

    public class Subscriber
    implements Runnable {
        @Override
        public void run() {
            String group = StreamPubSubProvider.GROUP_PREFIX + StreamPubSubProvider.this.getNodeId();
            log.debug((Object)("Starting subscriber thread with group: " + group));
            try (LogTailer tailer = ((StreamService)Framework.getService(StreamService.class)).getLogManager(StreamPubSubProvider.this.logConfig).createTailer(group, StreamPubSubProvider.this.logName, StreamPubSubProvider.this.codec);){
                tailer.toEnd();
                try {
                    while (true) {
                        LogRecord logRecord;
                        if ((logRecord = tailer.read(Duration.ofSeconds(5L))) == null) {
                            continue;
                        }
                        Record record = (Record)logRecord.message();
                        StreamPubSubProvider.this.localPublish(record.getKey(), record.getData());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.debug((Object)"Subscriber thread interrupted, exiting");
                    return;
                }
            }
        }
    }
}

