/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssCompressor {
    private final StringBuffer srcsb = new StringBuffer();

    public CssCompressor(Reader in) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            this.srcsb.append((char)c);
        }
    }

    protected String mergeRules(String inputCss) {
        LinkedHashMap<String, String> ruleMap = new LinkedHashMap<String, String>();
        StringBuffer mergedCss = new StringBuffer();
        Pattern p = Pattern.compile("([^\\{]*)\\{(.*?)\\}");
        Matcher m = p.matcher(inputCss);
        while (m.find()) {
            String selectors = m.group(1);
            String rules = m.group(2);
            if (ruleMap.containsKey(rules = this.compressDimensions(rules))) {
                ruleMap.put(rules, ruleMap.get(rules) + "," + selectors);
                continue;
            }
            ruleMap.put(rules, selectors);
        }
        for (String rule : ruleMap.keySet()) {
            mergedCss.append(ruleMap.get(rule) + "{" + rule + "}");
        }
        return mergedCss.toString();
    }

    protected String removeDuplicateProperties(String inputCssRule) {
        StringBuffer cssRule = new StringBuffer();
        LinkedHashSet<String> ruleSet = new LinkedHashSet<String>(Arrays.asList(inputCssRule.split(";")));
        Iterator i = ruleSet.iterator();
        while (i.hasNext()) {
            cssRule.append((String)i.next() + ";");
        }
        return cssRule.toString();
    }

    protected String compressDimensions(String inputCssRule) {
        Pattern p = Pattern.compile("(border|margin):(\\d+(?:\\p{Alpha}*))(\\2){3}");
        StringBuffer cssRule = new StringBuffer();
        for (String rule : inputCssRule.split(";")) {
            String condensedRule = rule.replaceAll(" +", "");
            Matcher m = p.matcher(condensedRule);
            if (m.find()) {
                cssRule.append(condensedRule.substring(0, m.start()));
                cssRule.append(m.group(1) + ':' + m.group(2) + ';');
                continue;
            }
            cssRule.append(rule + ';');
        }
        return cssRule.toString();
    }

    public void compress(Writer out, int linebreakpos) throws IOException {
        int startIndex = 0;
        boolean iemac = false;
        boolean preserve = false;
        StringBuffer sb = new StringBuffer(this.srcsb.toString());
        while ((startIndex = sb.indexOf("/*", startIndex)) >= 0) {
            preserve = sb.length() > startIndex + 2 && sb.charAt(startIndex + 2) == '!';
            int endIndex = sb.indexOf("*/", startIndex + 2);
            if (endIndex < 0) {
                if (preserve) continue;
                sb.delete(startIndex, sb.length());
                continue;
            }
            if (endIndex < startIndex + 2) continue;
            if (sb.charAt(endIndex - 1) == '\\') {
                startIndex = endIndex + 2;
                iemac = true;
                continue;
            }
            if (iemac) {
                startIndex = endIndex + 2;
                iemac = false;
                continue;
            }
            if (!preserve) {
                sb.delete(startIndex, endIndex + 2);
                continue;
            }
            startIndex = endIndex + 2;
        }
        String css = sb.toString();
        css = css.replaceAll("\\s+", " ");
        css = css.replaceAll("\"\\\\\"}\\\\\"\"", "___PSEUDOCLASSBMH___");
        sb = new StringBuffer();
        Pattern p = Pattern.compile("(^|\\})(([^\\{:])+:)+([^\\{]*\\{)");
        Matcher m = p.matcher(css);
        while (m.find()) {
            String s = m.group();
            s = s.replaceAll(":", "___PSEUDOCLASSCOLON___");
            m.appendReplacement(sb, s);
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("\\s+([!{};:>+\\(\\)\\],])", "$1");
        css = css.replaceAll("___PSEUDOCLASSCOLON___", ":");
        css = css.replaceAll("([!{}:;>+\\(\\[,])\\s+", "$1");
        css = css.replaceAll("([^;\\}])}", "$1;}");
        css = css.replaceAll("([\\s:])(0)(px|em|%|in|cm|mm|pc|pt|ex)", "$1$2");
        css = css.replaceAll(":0 0 0 0;", ":0;");
        css = css.replaceAll(":0 0 0;", ":0;");
        css = css.replaceAll(":0 0;", ":0;");
        css = css.replaceAll("background-position:0;", "background-position:0 0;");
        css = css.replaceAll("(:|\\s)0+\\.(\\d+)", "$1.$2");
        p = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
        m = p.matcher(css);
        sb = new StringBuffer();
        while (m.find()) {
            String[] rgbcolors = m.group(1).split(",");
            StringBuffer hexcolor = new StringBuffer("#");
            for (String rgbcolor : rgbcolors) {
                int val = Integer.parseInt(rgbcolor);
                if (val < 16) {
                    hexcolor.append("0");
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sb, hexcolor.toString());
        }
        m.appendTail(sb);
        css = sb.toString();
        p = Pattern.compile("([^\"'=\\s])(\\s*)#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])");
        m = p.matcher(css);
        sb = new StringBuffer();
        LinkedHashMap<String, String> colorMap = new LinkedHashMap<String, String>();
        colorMap.put("C0C0C0", "silver");
        colorMap.put("800000", "maroon");
        colorMap.put("800080", "purple");
        colorMap.put("008000", "green");
        colorMap.put("808000", "olive");
        colorMap.put("000080", "navy");
        colorMap.put("008080", "teal");
        while (m.find()) {
            if (m.group(3).equalsIgnoreCase(m.group(4)) && m.group(5).equalsIgnoreCase(m.group(6)) && m.group(7).equalsIgnoreCase(m.group(8))) {
                m.appendReplacement(sb, m.group(1) + m.group(2) + "#" + m.group(3) + m.group(5) + m.group(7));
                continue;
            }
            String hex = m.group(3) + m.group(4) + m.group(5) + m.group(6) + m.group(7) + m.group(8);
            if (colorMap.containsKey(hex)) {
                m.appendReplacement(sb, m.group(1) + m.group(2) + colorMap.get(hex));
                continue;
            }
            m.appendReplacement(sb, m.group());
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("[^\\}]+\\{;\\}", "");
        if (linebreakpos >= 0) {
            int i = 0;
            int linestartpos = 0;
            sb = new StringBuffer(css);
            while (i < sb.length()) {
                char c;
                if ((c = sb.charAt(i++)) != '}' || i - linestartpos <= linebreakpos) continue;
                sb.insert(i, '\n');
                linestartpos = i;
            }
            css = sb.toString();
        }
        css = css.replaceAll("___PSEUDOCLASSBMH___", "\"\\\\\"}\\\\\"\"");
        css = css.replaceAll(";;+", ";");
        css = css.trim();
        css = this.mergeRules(css);
        css = css.replaceAll(";\\}", "}");
        out.write(css);
    }
}

