/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.query.QueryBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchDocWriterDescriptor;
import org.nuxeo.elasticsearch.config.ElasticSearchEmbeddedServerConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.core.ElasticSearchIndexingImpl;
import org.nuxeo.elasticsearch.core.ElasticSearchServiceImpl;
import org.nuxeo.elasticsearch.io.JsonESDocumentWriter;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.work.IndexingWorker;
import org.nuxeo.elasticsearch.work.ScrollingIndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchComponent
extends DefaultComponent
implements ElasticSearchAdmin,
ElasticSearchIndexing,
ElasticSearchService {
    protected static final Log log = LogFactory.getLog(ElasticSearchComponent.class);
    protected static final String EP_EMBEDDED_SERVER = "elasticSearchEmbeddedServer";
    protected static final String EP_CLIENT_INIT = "elasticSearchClient";
    protected static final String EP_INDEX = "elasticSearchIndex";
    protected static final String EP_DOC_WRITER = "elasticSearchDocWriter";
    protected static final long REINDEX_TIMEOUT = 20L;
    protected final List<IndexingCommand> stackedCommands = Collections.synchronizedList(new ArrayList());
    protected final Map<String, ElasticSearchIndexConfig> indexConfig = new HashMap<String, ElasticSearchIndexConfig>();
    protected final AtomicInteger runIndexingWorkerCount = new AtomicInteger(0);
    protected ElasticSearchEmbeddedServerConfig embeddedServerConfig;
    protected ElasticSearchClientConfig clientConfig;
    protected ElasticSearchAdminImpl esa;
    protected ElasticSearchIndexingImpl esi;
    protected ElasticSearchServiceImpl ess;
    protected JsonESDocumentWriter jsonESDocumentWriter;
    protected ListeningExecutorService waiterExecutorService;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "elasticSearchEmbeddedServer": {
                ElasticSearchEmbeddedServerConfig serverContrib = (ElasticSearchEmbeddedServerConfig)contribution;
                if (serverContrib.isEnabled()) {
                    this.embeddedServerConfig = serverContrib;
                    log.info((Object)("Registering embedded server configuration: " + this.embeddedServerConfig + ", loaded from " + contributor.getName()));
                    break;
                }
                if (this.embeddedServerConfig == null) break;
                log.info((Object)("Disabling previous embedded server configuration, deactivated by " + contributor.getName()));
                this.embeddedServerConfig = null;
                break;
            }
            case "elasticSearchClient": {
                this.clientConfig = (ElasticSearchClientConfig)contribution;
                break;
            }
            case "elasticSearchIndex": {
                ElasticSearchIndexConfig idx = (ElasticSearchIndexConfig)contribution;
                ElasticSearchIndexConfig previous = this.indexConfig.get(idx.getName());
                if (idx.isEnabled()) {
                    idx.merge(previous);
                    this.indexConfig.put(idx.getName(), idx);
                    log.info((Object)("Registering index configuration: " + idx + ", loaded from " + contributor.getName()));
                    break;
                }
                if (previous == null) break;
                log.info((Object)("Disabling index configuration: " + previous + ", deactivated by " + contributor.getName()));
                this.indexConfig.remove(idx.getName());
                break;
            }
            case "elasticSearchDocWriter": {
                ElasticSearchDocWriterDescriptor writerDescriptor = (ElasticSearchDocWriterDescriptor)contribution;
                try {
                    this.jsonESDocumentWriter = writerDescriptor.getKlass().newInstance();
                    break;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.error((Object)("Cannot instantiate jsonESDocumentWriter from " + writerDescriptor.getKlass()));
                    throw new NuxeoException((Throwable)e);
                }
            }
            default: {
                throw new IllegalStateException("Invalid EP: " + extensionPoint);
            }
        }
    }

    public void start(ComponentContext context) {
        if (!this.isElasticsearchEnabled()) {
            log.info((Object)"Elasticsearch service is disabled");
            return;
        }
        this.esa = new ElasticSearchAdminImpl(this.embeddedServerConfig, this.clientConfig, this.indexConfig);
        this.esi = new ElasticSearchIndexingImpl(this.esa, this.jsonESDocumentWriter);
        this.ess = new ElasticSearchServiceImpl(this.esa);
        this.initListenerThreadPool();
        this.processStackedCommands();
        this.reindexOnStartup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext context) {
        if (this.esa == null) {
            return;
        }
        try {
            this.shutdownListenerThreadPool();
        }
        finally {
            try {
                this.esa.disconnect();
            }
            finally {
                this.esa = null;
                this.esi = null;
                this.ess = null;
            }
        }
    }

    protected void reindexOnStartup() {
        boolean reindexOnStartup = Boolean.parseBoolean(Framework.getProperty((String)"elasticsearch.reindex.onStartup", (String)"false"));
        if (!reindexOnStartup) {
            return;
        }
        for (String repositoryName : this.esa.getInitializedRepositories()) {
            log.warn((Object)String.format("Indexing repository: %s on startup", repositoryName));
            this.runReindexingWorker(repositoryName, "SELECT ecm:uuid FROM Document");
            try {
                this.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (TimeoutException e) {
                log.warn((Object)String.format("Indexation of repository %s not finished after %d s, continuing in background", repositoryName, 20L));
            }
        }
    }

    protected boolean isElasticsearchEnabled() {
        return Boolean.parseBoolean(Framework.getProperty((String)"elasticsearch.enabled", (String)"true"));
    }

    public int getApplicationStartedOrder() {
        RepositoryService component = (RepositoryService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        return component.getApplicationStartedOrder() / 2;
    }

    void processStackedCommands() {
        if (!this.stackedCommands.isEmpty()) {
            log.info((Object)String.format("Processing %d indexing commands stacked during startup", this.stackedCommands.size()));
            this.runIndexingWorker(this.stackedCommands);
            this.stackedCommands.clear();
            log.debug((Object)"Done");
        }
    }

    @Override
    public ESClient getClient() {
        return this.esa.getClient();
    }

    @Override
    public void initIndexes(boolean dropIfExists) {
        this.esa.initIndexes(dropIfExists);
    }

    @Override
    public void dropAndInitIndex(String indexName) {
        this.esa.dropAndInitIndex(indexName);
    }

    @Override
    public void dropAndInitRepositoryIndex(String repositoryName, boolean syncAlias) {
        this.esa.dropAndInitRepositoryIndex(repositoryName, syncAlias);
    }

    @Override
    public List<String> getRepositoryNames() {
        return this.esa.getRepositoryNames();
    }

    @Override
    public String getIndexNameForRepository(String repositoryName) {
        return this.esa.getIndexNameForRepository(repositoryName);
    }

    @Override
    public String getRepositoryForIndex(String indexName) {
        return this.esa.getRepositoryForIndex(indexName);
    }

    @Override
    public List<String> getIndexNamesForType(String type) {
        return this.esa.getIndexNamesForType(type);
    }

    @Override
    public String getIndexNameForType(String type) {
        return this.esa.getIndexNameForType(type);
    }

    @Override
    public String getWriteIndexName(String searchIndexName) {
        return this.esa.getWriteIndexName(searchIndexName);
    }

    @Override
    public void syncSearchAndWriteAlias(String searchIndexName) {
        this.esa.syncSearchAndWriteAlias(searchIndexName);
    }

    @Override
    public long getPendingWorkerCount() {
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        return wm.getQueueSize("elasticSearchIndexing", Work.State.SCHEDULED);
    }

    @Override
    public long getRunningWorkerCount() {
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        return this.runIndexingWorkerCount.get() + wm.getQueueSize("elasticSearchIndexing", Work.State.RUNNING);
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.esa.getTotalCommandProcessed();
    }

    @Override
    public boolean isEmbedded() {
        return this.esa.isEmbedded();
    }

    @Override
    public boolean useExternalVersion() {
        return this.esa.useExternalVersion();
    }

    @Override
    public boolean isIndexingInProgress() {
        return this.runIndexingWorkerCount.get() > 0 || this.getPendingWorkerCount() > 0L || this.getRunningWorkerCount() > 0L;
    }

    @Override
    public ListenableFuture<Boolean> prepareWaitForIndexing() {
        return this.waiterExecutorService.submit(() -> {
            boolean completed;
            WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
            while (!(completed = wm.awaitCompletion("elasticSearchIndexing", 300L, TimeUnit.SECONDS))) {
            }
            return true;
        });
    }

    protected void initListenerThreadPool() {
        this.waiterExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new NamedThreadFactory()));
    }

    protected void shutdownListenerThreadPool() {
        try {
            this.waiterExecutorService.shutdown();
        }
        finally {
            this.waiterExecutorService = null;
        }
    }

    @Override
    public void refresh() {
        this.esa.refresh();
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        this.esa.refreshRepositoryIndex(repositoryName);
    }

    @Override
    public void flush() {
        this.esa.flush();
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        this.esa.flushRepositoryIndex(repositoryName);
    }

    @Override
    public void optimize() {
        this.esa.optimize();
    }

    @Override
    public void optimizeRepositoryIndex(String repositoryName) {
        this.esa.optimizeRepositoryIndex(repositoryName);
    }

    @Override
    public void optimizeIndex(String indexName) {
        this.esa.optimizeIndex(indexName);
    }

    @Override
    public void indexNonRecursive(IndexingCommand cmd) {
        this.indexNonRecursive(Collections.singletonList(cmd));
    }

    @Override
    public void indexNonRecursive(List<IndexingCommand> cmds) {
        if (!this.isReady()) {
            this.stackCommands(cmds);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process indexing commands: " + Arrays.toString(cmds.toArray())));
        }
        this.esi.indexNonRecursive(cmds);
    }

    protected void stackCommands(List<IndexingCommand> cmds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delaying indexing commands: Waiting for Index to be initialized." + Arrays.toString(cmds.toArray())));
        }
        this.stackedCommands.addAll(cmds);
    }

    @Override
    public void runIndexingWorker(List<IndexingCommand> cmds) {
        if (!this.isReady()) {
            this.stackCommands(cmds);
            return;
        }
        this.runIndexingWorkerCount.incrementAndGet();
        try {
            this.dispatchWork(cmds);
        }
        finally {
            this.runIndexingWorkerCount.decrementAndGet();
        }
    }

    protected void dispatchWork(List<IndexingCommand> cmds) {
        HashMap<String, List<IndexingCommand>> syncCommands = new HashMap<String, List<IndexingCommand>>();
        HashMap<String, List<IndexingCommand>> asyncCommands = new HashMap<String, List<IndexingCommand>>();
        for (IndexingCommand cmd : cmds) {
            if (cmd.isSync()) {
                ArrayList<IndexingCommand> syncCmds = (ArrayList<IndexingCommand>)syncCommands.get(cmd.getRepositoryName());
                if (syncCmds == null) {
                    syncCmds = new ArrayList<IndexingCommand>();
                }
                syncCmds.add(cmd);
                syncCommands.put(cmd.getRepositoryName(), syncCmds);
                continue;
            }
            ArrayList<IndexingCommand> asyncCmds = (ArrayList<IndexingCommand>)asyncCommands.get(cmd.getRepositoryName());
            if (asyncCmds == null) {
                asyncCmds = new ArrayList<IndexingCommand>();
            }
            asyncCmds.add(cmd);
            asyncCommands.put(cmd.getRepositoryName(), asyncCmds);
        }
        this.runIndexingSyncWorker(syncCommands);
        this.scheduleIndexingAsyncWorker(asyncCommands);
    }

    protected void scheduleIndexingAsyncWorker(Map<String, List<IndexingCommand>> asyncCommands) {
        if (asyncCommands.isEmpty()) {
            return;
        }
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        for (String repositoryName : asyncCommands.keySet()) {
            IndexingWorker idxWork = new IndexingWorker(repositoryName, asyncCommands.get(repositoryName));
            wm.schedule((Work)idxWork, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runIndexingSyncWorker(Map<String, List<IndexingCommand>> syncCommands) {
        if (syncCommands.isEmpty()) {
            return;
        }
        Transaction transaction = TransactionHelper.suspendTransaction();
        try {
            for (String repositoryName : syncCommands.keySet()) {
                IndexingWorker idxWork = new IndexingWorker(repositoryName, syncCommands.get(repositoryName));
                idxWork.run();
            }
        }
        finally {
            if (transaction != null) {
                TransactionHelper.resumeTransaction((Transaction)transaction);
            }
        }
    }

    @Override
    public void runReindexingWorker(String repositoryName, String nxql, boolean syncAlias) {
        if (nxql == null || nxql.isEmpty()) {
            throw new IllegalArgumentException("Expecting an NXQL query");
        }
        ScrollingIndexingWorker worker = new ScrollingIndexingWorker(repositoryName, nxql, syncAlias);
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        wm.schedule((Work)worker);
    }

    @Override
    public void reindexRepository(String repositoryName) {
        this.esa.dropAndInitRepositoryIndex(repositoryName, false);
        this.runReindexingWorker(repositoryName, "SELECT ecm:uuid FROM Document", true);
    }

    @Override
    public BytesReference source(DocumentModel doc) throws IOException {
        return this.esi.source(doc);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) {
        return this.ess.query(queryBuilder);
    }

    @Override
    public EsResult queryAndAggregate(NxQueryBuilder queryBuilder) {
        return this.ess.queryAndAggregate(queryBuilder);
    }

    @Override
    public EsScrollResult scroll(NxQueryBuilder queryBuilder, long keepAlive) {
        return this.ess.scroll(queryBuilder, keepAlive);
    }

    @Override
    public EsScrollResult scroll(EsScrollResult scrollResult) {
        return this.ess.scroll(scrollResult);
    }

    @Override
    public void clearScroll(EsScrollResult scrollResult) {
        this.ess.clearScroll(scrollResult);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    protected boolean isReady() {
        return this.esa != null && this.esa.isReady();
    }

    protected static class NamedThreadFactory
    implements ThreadFactory {
        protected NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "waitForEsIndexing");
        }
    }
}

