/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.core.AggregateBase;

public abstract class AggregateEsBase<A extends Aggregation, B extends Bucket>
extends AggregateBase<B> {
    public static final char XPATH_SEP = '/';
    public static final char ES_MUTLI_LEVEL_SEP = '.';
    public static final int MAX_AGG_SIZE = 1000;

    public AggregateEsBase(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    public abstract AggregationBuilder getEsAggregate();

    public abstract QueryBuilder getEsFilter();

    public abstract void parseAggregation(A var1);

    public String getField() {
        String ret = super.getField();
        if ("ecm:fulltext".equals(ret)) {
            ret = "all_field";
        }
        ret = ret.replace('/', '.');
        return ret;
    }

    protected int getAggSize(String prop) {
        int size = Integer.parseInt(prop);
        return size == 0 ? 1000 : size;
    }
}

