/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import org.joda.time.DateTime;

public final class DateHelper {
    private DateHelper() {
    }

    public static DateTime plusDuration(DateTime origin, String duration) {
        if (duration.matches("[a-zA-Z]+")) {
            return DateHelper.plusDurationAsNoun(origin, duration);
        }
        if (duration.matches("[0-9]+")) {
            return origin.plusMillis(Integer.valueOf(duration).intValue());
        }
        return DateHelper.plusDurationAsExpression(origin, duration);
    }

    private static DateTime plusDurationAsExpression(DateTime origin, String duration) {
        int k = DateHelper.getFactor(duration);
        switch (duration.substring(duration.length() - 1, duration.length())) {
            case "s": {
                return origin.plusSeconds(k);
            }
            case "m": {
                return origin.plusMinutes(k);
            }
            case "h": {
                return origin.plusHours(k);
            }
            case "d": {
                return origin.plusDays(k);
            }
            case "w": {
                return origin.plusWeeks(k);
            }
            case "M": {
                return origin.plusMonths(k);
            }
            case "y": {
                return origin.plusYears(k);
            }
        }
        return DateHelper.invalid(duration);
    }

    private static int getFactor(String duration) {
        try {
            return Integer.valueOf(duration.substring(0, duration.length() - 1));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            DateHelper.invalid(duration);
            return 1;
        }
    }

    private static DateTime plusDurationAsNoun(DateTime origin, String duration) {
        switch (duration.toLowerCase()) {
            case "second": {
                return origin.plusSeconds(1);
            }
            case "minute": {
                return origin.plusMinutes(1);
            }
            case "hour": {
                return origin.plusHours(1);
            }
            case "day": {
                return origin.plusDays(1);
            }
            case "week": {
                return origin.plusWeeks(1);
            }
            case "month": {
                return origin.plusMonths(1);
            }
            case "quarter": {
                return origin.plusMonths(3);
            }
            case "year": {
                return origin.plusYears(1);
            }
        }
        return DateHelper.invalid(duration);
    }

    private static DateTime invalid(String msg) {
        throw new IllegalArgumentException("Invalid duration: " + msg);
    }
}

