/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;

public class ESRestClient
implements ESClient {
    private static final Log log = LogFactory.getLog(ESRestClient.class);
    public static final String CREATE_INDEX_TIMEOUT = "60s";
    protected RestClient lowLevelClient;
    protected RestHighLevelClient client;

    public ESRestClient(RestClient lowLevelRestClient, RestHighLevelClient client) {
        this.lowLevelClient = lowLevelRestClient;
        this.client = client;
    }

    @Override
    public boolean waitForYellowStatus(String[] indexNames, int timeoutSecond) {
        ClusterHealthStatus healthStatus;
        Response response;
        try {
            response = this.performRequest(new Request("GET", String.format("/_cluster/health/%s?wait_for_status=yellow&timeout=%ds", this.getIndexesAsString(indexNames), timeoutSecond)));
            try (InputStream is = response.getEntity().getContent();){
                Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
                healthStatus = ClusterHealthStatus.fromString((String)((String)map.get("status")));
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        switch (healthStatus) {
            case GREEN: {
                log.info((Object)("Elasticsearch Cluster ready: " + response));
                return true;
            }
            case YELLOW: {
                log.warn((Object)("Elasticsearch Cluster ready but not GREEN: " + response));
                return false;
            }
        }
        String error = "Elasticsearch Cluster health status: " + healthStatus + ", not Yellow after " + timeoutSecond + " give up: " + response;
        throw new IllegalStateException(error);
    }

    protected String getIndexesAsString(String[] indexNames) {
        return indexNames == null ? "" : String.join((CharSequence)",", indexNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterHealthStatus getHealthStatus(String[] indexNames) {
        Response response = this.performRequest(new Request("GET", String.format("/_cluster/health/%s", this.getIndexesAsString(indexNames))));
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            ClusterHealthStatus clusterHealthStatus = ClusterHealthStatus.fromString((String)((String)map.get("status")));
            return clusterHealthStatus;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void refresh(String indexName) {
        this.performRequest(new Request("POST", "/" + indexName + "/_refresh"));
    }

    @Override
    public void flush(String indexName) {
        this.performRequest(new Request("POST", "/" + indexName + "/_flush?wait_if_ongoing=true"));
    }

    @Override
    public void optimize(String indexName) {
        this.performRequest(new Request("POST", "/" + indexName + "/_forcemerge?max_num_segments=1"));
    }

    @Override
    public boolean indexExists(String indexName) {
        Response response = this.performRequest(new Request("HEAD", "/" + indexName));
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Checking index %s returns: %s", indexName, response));
    }

    @Override
    public boolean mappingExists(String indexName, String type) {
        Response response = this.performRequest(new Request("HEAD", String.format("/%s/_mapping/%s", indexName, type)));
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Checking mapping %s returns: %s", indexName, response));
    }

    @Override
    public void deleteIndex(String indexName, int timeoutSecond) {
        Response response;
        try {
            response = this.lowLevelClient.performRequest(new Request("DELETE", String.format("/%s?master_timeout=%ds", indexName, timeoutSecond)));
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("illegal_argument_exception")) {
                throw new IllegalArgumentException(e);
            }
            throw new NuxeoException((Throwable)e);
        }
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IllegalStateException(String.format("Deleting %s returns: %s", indexName, response));
        }
    }

    @Override
    public void createIndex(String indexName, String jsonSettings) {
        Request request = new Request("PUT", "/" + indexName + "?timeout=" + CREATE_INDEX_TIMEOUT);
        request.setJsonEntity(jsonSettings);
        Response response = this.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException("Fail to create index: " + indexName + " :" + response);
        }
    }

    @Override
    public void createMapping(String indexName, String type, String jsonMapping) {
        Request request = new Request("PUT", String.format("/%s/%s/_mapping", indexName, type));
        request.setJsonEntity(jsonMapping);
        Response response = this.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException(String.format("Fail to create mapping on %s/%s: %s", indexName, type, response));
        }
    }

    protected Response performRequest(Request request) {
        try {
            return this.lowLevelClient.performRequest(request);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String getNodesInfo() {
        Response response = this.performRequest(new Request("GET", "/_nodes/_all"));
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String getNodesStats() {
        Response response = this.performRequest(new Request("GET", "/_nodes/stats"));
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public boolean aliasExists(String aliasName) {
        Response response = this.performRequest(new Request("HEAD", String.format("/_alias/%s", aliasName)));
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Checking alias %s returns: %s", aliasName, response));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFirstIndexForAlias(String aliasName) {
        if (!this.aliasExists(aliasName)) {
            return null;
        }
        Response response = this.performRequest(new Request("GET", String.format("/_alias/%s", aliasName)));
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            if (map.size() != 1) {
                throw new NuxeoException(String.format("Expecting alias that point to a single index, alias: %s, got: %s", aliasName, response));
            }
            String string = (String)map.keySet().iterator().next();
            return string;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void updateAlias(String aliasName, String indexName) {
        if (this.aliasExists(aliasName)) {
            this.deleteAlias(aliasName);
        }
        if (this.indexExists(aliasName)) {
            throw new NuxeoException("Can create an alias because an index with the same name exists: " + aliasName);
        }
        this.createAlias(aliasName, indexName);
    }

    protected void deleteAlias(String aliasName) {
        Response response = this.performRequest(new Request("DELETE", String.format("/_all/_alias/%s", aliasName)));
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IllegalStateException(String.format("Deleting %s alias: %s", aliasName, response));
        }
    }

    protected void createAlias(String aliasName, String indexName) {
        Response response = this.performRequest(new Request("PUT", String.format("/%s/_alias/%s", indexName, aliasName)));
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NuxeoException("Fail to create alias: " + indexName + " :" + response);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest request) {
        try {
            return this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest request) {
        try {
            return this.client.delete(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public SearchResponse searchScroll(SearchScrollRequest request) {
        try {
            return this.client.scroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public GetResponse get(GetRequest request) {
        try {
            return this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public IndexResponse index(IndexRequest request) {
        try {
            return this.client.index(request, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchStatusException e) {
            if (RestStatus.CONFLICT.equals((Object)e.status())) {
                throw new ConcurrentUpdateException((Throwable)e);
            }
            throw new NuxeoException((Throwable)e);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Clearing scroll ids: %s", Arrays.toString(request.getScrollIds().toArray())));
            }
            return this.client.clearScroll(request, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchStatusException e) {
            if (RestStatus.NOT_FOUND.equals((Object)e.status())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Scroll ids not found, they have certainly been already closed: %s", Arrays.toString(request.getScrollIds().toArray())));
                }
                return new ClearScrollResponse(true, 0);
            }
            throw new NuxeoException((Throwable)e);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public BulkProcessor.Builder bulkProcessorBuilder(BulkProcessor.Listener bulkListener) {
        return BulkProcessor.builder((request, listener) -> this.client.bulkAsync(request, RequestOptions.DEFAULT, listener), (BulkProcessor.Listener)bulkListener);
    }

    @Override
    public void close() {
        if (this.lowLevelClient != null) {
            try {
                this.lowLevelClient.close();
            }
            catch (IOException e) {
                log.warn((Object)("Fail to close the Elasticsearch low level RestClient: " + e.getMessage()), (Throwable)e);
            }
            this.lowLevelClient = null;
        }
        this.client = null;
    }
}

