/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESClientFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchEmbeddedServerConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchEmbeddedNode;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchAdminImpl
implements ElasticSearchAdmin {
    private static final Log log = LogFactory.getLog(ElasticSearchAdminImpl.class);
    protected static final int TIMEOUT_WAIT_FOR_CLUSTER_SECOND = 30;
    protected static final int TIMEOUT_DELETE_SECOND = 300;
    protected final AtomicInteger totalCommandProcessed = new AtomicInteger(0);
    protected final Map<String, String> indexNames = new HashMap<String, String>();
    protected final Map<String, String> repoNames = new HashMap<String, String>();
    protected final Map<String, String> writeIndexNames = new HashMap<String, String>();
    protected final Map<String, ElasticSearchIndexConfig> indexConfig;
    protected final ElasticSearchEmbeddedServerConfig embeddedServerConfig;
    protected final ElasticSearchClientConfig clientConfig;
    protected ElasticSearchEmbeddedNode embeddedServer;
    protected ESClient client;
    protected boolean indexInitDone;
    protected String[] includeSourceFields;
    protected String[] excludeSourceFields;
    protected List<String> repositoryInitialized = new ArrayList<String>();

    public ElasticSearchAdminImpl(ElasticSearchEmbeddedServerConfig embeddedServerConfig, ElasticSearchClientConfig clientConfig, Map<String, ElasticSearchIndexConfig> indexConfig) {
        this.embeddedServerConfig = embeddedServerConfig;
        this.indexConfig = indexConfig;
        this.clientConfig = clientConfig;
        this.checkConfig();
        this.connect();
        this.initializeIndexes();
    }

    protected void checkConfig() {
        if (this.clientConfig == null) {
            throw new IllegalStateException("No Elasticsearch Client configuration provided, aborting");
        }
    }

    protected void connect() {
        if (this.client != null) {
            return;
        }
        if (this.embeddedServerConfig != null) {
            this.embeddedServer = new ElasticSearchEmbeddedNode(this.embeddedServerConfig);
            this.embeddedServer.start();
        }
        this.client = this.createClient(this.embeddedServer);
        this.checkClusterHealth(new String[0]);
        log.info((Object)"Elasticsearch Connected");
    }

    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close client: " + e.getMessage()), (Throwable)e);
            }
            this.client = null;
            this.indexInitDone = false;
            log.info((Object)"Elasticsearch Disconnected");
        }
        if (this.embeddedServer != null) {
            try {
                this.embeddedServer.close();
            }
            catch (IOException e) {
                log.error((Object)("Failed to close embedded node: " + e.getMessage()), (Throwable)e);
            }
            this.embeddedServer = null;
            log.info((Object)"Elasticsearch embedded Node Stopped");
        }
    }

    protected ESClient createClient(ElasticSearchEmbeddedNode node) {
        ESClient ret;
        log.info((Object)"Connecting to Elasticsearch");
        try {
            ESClientFactory clientFactory = this.clientConfig.getKlass().newInstance();
            ret = clientFactory.create(node, this.clientConfig);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)("Cannot instantiate Elasticsearch Client from class: " + this.clientConfig.getKlass()));
            throw new NuxeoException((Throwable)e);
        }
        return ret;
    }

    protected void checkClusterHealth(String ... indexNames) {
        if (this.client == null) {
            throw new IllegalStateException("No Elasticsearch Client available");
        }
        this.client.waitForYellowStatus(indexNames, 30);
    }

    protected void initializeIndexes() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.isDocumentIndex()) continue;
            log.info((Object)("Associate index " + conf.getName() + " with repository: " + conf.getRepositoryName()));
            this.indexNames.put(conf.getRepositoryName(), conf.getName());
            this.repoNames.put(conf.getName(), conf.getRepositoryName());
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            if (this.includeSourceFields != null) {
                set.addAll(Arrays.asList(this.includeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getIncludes()));
            if (set.contains("*")) {
                set.clear();
                set.add("*");
            }
            this.includeSourceFields = set.toArray(new String[set.size()]);
            set.clear();
            if (this.excludeSourceFields != null) {
                set.addAll(Arrays.asList(this.excludeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getExcludes()));
            this.excludeSourceFields = set.toArray(new String[set.size()]);
        }
        this.initIndexes(false);
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing index associated with repo: " + repositoryName));
        }
        this.getClient().refresh(this.getWriteIndexName(this.getIndexNameForRepository(repositoryName)));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refreshing index done");
        }
    }

    @Override
    public String getIndexNameForRepository(String repositoryName) {
        String ret = this.indexNames.get(repositoryName);
        if (ret == null) {
            throw new NoSuchElementException("No index defined for repository: " + repositoryName);
        }
        return ret;
    }

    @Override
    public String getRepositoryForIndex(String indexName) {
        return this.repoNames.get(indexName);
    }

    @Override
    public List<String> getIndexNamesForType(String type) {
        ArrayList<String> indexNames = new ArrayList<String>();
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!type.equals(conf.getType())) continue;
            indexNames.add(conf.getName());
        }
        return indexNames;
    }

    @Override
    public String getIndexNameForType(String type) {
        List<String> indexNames = this.getIndexNamesForType(type);
        if (indexNames.isEmpty()) {
            throw new NoSuchElementException("No index defined for type: " + type);
        }
        return indexNames.get(0);
    }

    @Override
    public String getWriteIndexName(String searchIndexName) {
        return this.writeIndexNames.getOrDefault(searchIndexName, searchIndexName);
    }

    @Override
    public void syncSearchAndWriteAlias(String searchIndexName) {
        ElasticSearchIndexConfig conf = this.indexConfig.values().stream().filter(item -> item.getName().equals(searchIndexName)).findFirst().orElseThrow(IllegalStateException::new);
        this.syncSearchAndWriteAlias(conf);
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        log.warn((Object)("Flushing index associated with repo: " + repositoryName));
        this.getClient().flush(this.getWriteIndexName(this.getIndexNameForRepository(repositoryName)));
        log.info((Object)"Flushing index done");
    }

    @Override
    public void refresh() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.refreshRepositoryIndex(repositoryName);
        }
    }

    @Override
    public void flush() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.flushRepositoryIndex(repositoryName);
        }
    }

    @Override
    public void optimizeIndex(String indexName) {
        log.warn((Object)("Optimizing index: " + indexName));
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.getClient().optimize(indexName);
        }
        log.info((Object)"Optimize done");
    }

    @Override
    public void optimizeRepositoryIndex(String repositoryName) {
        this.optimizeIndex(this.getIndexNameForRepository(repositoryName));
    }

    @Override
    public void optimize() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.optimizeIndex(conf.getName());
        }
    }

    @Override
    public ESClient getClient() {
        return this.client;
    }

    @Override
    public void initIndexes(boolean dropIfExists) {
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.initIndex(conf, dropIfExists);
        }
        log.info((Object)"Elasticsearch Service ready");
        this.indexInitDone = true;
    }

    @Override
    public void dropAndInitIndex(String indexName) {
        log.info((Object)("Drop and init index: " + indexName));
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.initIndex(conf, true);
        }
        this.indexInitDone = true;
    }

    @Override
    public void dropAndInitRepositoryIndex(String repositoryName, boolean syncAlias) {
        log.info((Object)("Drop and init index of repository: " + repositoryName));
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.isDocumentIndex() || !repositoryName.equals(conf.getRepositoryName())) continue;
            this.initIndex(conf, true, syncAlias);
        }
        this.indexInitDone = true;
    }

    @Override
    public List<String> getRepositoryNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.indexNames.keySet()));
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        this.initIndex(conf, dropIfExists, true);
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists, boolean syncAlias) {
        if (conf.manageAlias()) {
            this.initWriteAlias(conf, dropIfExists);
            this.initSearchAlias(conf);
            this.writeIndexNames.put(conf.getName(), conf.writeIndexOrAlias());
            if (syncAlias) {
                this.syncSearchAndWriteAlias(conf);
            }
        } else if (conf.hasExplicitWriteIndex()) {
            this.initIndex(conf.writeIndexOrAlias(), conf, dropIfExists);
            this.writeIndexNames.put(conf.getName(), conf.writeIndexOrAlias());
        } else {
            this.initIndex(conf.getName(), conf, dropIfExists);
            this.writeIndexNames.put(conf.getName(), conf.getName());
        }
    }

    protected void initWriteAlias(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        String nextWriteIndex = conf.newWriteIndexForAlias(conf.getName(), writeIndex);
        if (writeIndex != null && !dropIfExists) {
            this.initIndex(writeIndex, conf, false);
        } else {
            if (this.getClient().indexExists(nextWriteIndex)) {
                throw new IllegalStateException(String.format("New index name %s for the alias %s already exists", nextWriteIndex, writeAlias));
            }
            this.initIndex(nextWriteIndex, conf, false);
            this.getClient().updateAlias(writeAlias, nextWriteIndex);
        }
    }

    protected void initSearchAlias(ElasticSearchIndexConfig conf) {
        String searchAlias = conf.getName();
        String searchIndex = this.getClient().getFirstIndexForAlias(searchAlias);
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        if (searchIndex == null) {
            if (this.getClient().indexExists(searchAlias)) {
                if (Framework.isTestModeSet()) {
                    this.getClient().deleteIndex(searchAlias, 300);
                }
                searchIndex = searchAlias;
            } else {
                this.getClient().updateAlias(searchAlias, writeIndex);
                searchIndex = writeIndex;
            }
        }
        log.info((Object)String.format("Managed index aliases: Alias: %s ->  index: %s, alias: %s ->  index: %s", searchAlias, searchIndex, writeAlias, writeIndex));
    }

    protected void syncSearchAndWriteAlias(ElasticSearchIndexConfig conf) {
        if (!conf.manageAlias()) {
            return;
        }
        String searchAlias = conf.getName();
        String searchIndex = this.getClient().getFirstIndexForAlias(searchAlias);
        String writeAlias = conf.writeIndexOrAlias();
        String writeIndex = this.getClient().getFirstIndexForAlias(writeAlias);
        if (!writeIndex.equals(searchIndex)) {
            log.warn((Object)String.format("Updating search alias %s->%s (previously %s)", searchAlias, writeIndex, searchIndex));
            this.getClient().updateAlias(searchAlias, writeIndex);
            searchIndex = writeIndex;
        }
        if (searchIndex != null) {
            this.repoNames.put(searchIndex, conf.getRepositoryName());
        }
    }

    protected void initIndex(String indexName, ElasticSearchIndexConfig conf, boolean dropIfExists) {
        if (!conf.mustCreate()) {
            return;
        }
        log.info((Object)String.format("Initialize index: %s with conf: %s, type: %s", indexName, conf.getName(), conf.getType()));
        boolean mappingExists = false;
        boolean indexExists = this.getClient().indexExists(indexName);
        if (indexExists) {
            if (!dropIfExists) {
                String realIndexForAlias;
                log.debug((Object)("Index " + indexName + " already exists"));
                mappingExists = this.getClient().mappingExists(indexName, conf.getType());
                if (conf.isDocumentIndex() && (realIndexForAlias = this.getClient().getFirstIndexForAlias(conf.getName())) != null) {
                    this.repoNames.put(realIndexForAlias, conf.getRepositoryName());
                }
            } else {
                if (!Framework.isTestModeSet()) {
                    log.warn((Object)String.format("Initializing index: %s, type: %s with dropIfExists flag, deleting an existing index", indexName, conf.getType()));
                }
                this.getClient().deleteIndex(indexName, 300);
                indexExists = false;
            }
        }
        if (!indexExists) {
            log.info((Object)String.format("Creating index: %s", indexName));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using settings: " + conf.getSettings()));
            }
            this.getClient().createIndex(indexName, conf.getSettings());
        }
        if (!mappingExists) {
            log.info((Object)String.format("Creating mapping type: %s on index: %s", indexName, conf.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using mapping: " + conf.getMapping()));
            }
            this.getClient().createMapping(indexName, conf.getType(), conf.getMapping());
            if (!dropIfExists && conf.getRepositoryName() != null) {
                this.repositoryInitialized.add(conf.getRepositoryName());
            }
        }
        this.checkClusterHealth(indexName);
    }

    @Override
    public long getPendingWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public long getRunningWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.totalCommandProcessed.get();
    }

    @Override
    public boolean isEmbedded() {
        return this.embeddedServer != null;
    }

    @Override
    public boolean useExternalVersion() {
        return this.clientConfig.useExternalVersion();
    }

    @Override
    public boolean isIndexingInProgress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ListenableFuture<Boolean> prepareWaitForIndexing() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected String[] getSearchIndexes(List<String> searchRepositories) {
        if (searchRepositories.isEmpty()) {
            Collection<String> values = this.indexNames.values();
            return values.toArray(new String[values.size()]);
        }
        String[] ret = new String[searchRepositories.size()];
        int i = 0;
        for (String repo : searchRepositories) {
            ret[i++] = this.getIndexNameForRepository(repo);
        }
        return ret;
    }

    public boolean isReady() {
        return this.indexInitDone;
    }

    protected String[] getIncludeSourceFields() {
        return this.includeSourceFields;
    }

    protected String[] getExcludeSourceFields() {
        return this.excludeSourceFields;
    }

    protected Map<String, String> getRepositoryMap() {
        return this.repoNames;
    }

    public List<String> getInitializedRepositories() {
        return this.repositoryInitialized;
    }
}

