/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.elasticsearch.api.IndexNameGenerator;

public class IncrementalIndexNameGenerator
implements IndexNameGenerator {
    protected static final String SEP = "-";

    @Override
    public String getNextIndexName(String aliasName, String oldIndexName) {
        if (StringUtils.isEmpty((CharSequence)oldIndexName)) {
            return aliasName + SEP + "0000";
        }
        int i = oldIndexName.lastIndexOf(SEP);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid index name: " + oldIndexName);
        }
        int index = Integer.parseInt(oldIndexName.substring(i + 1)) + 1;
        return String.format("%s%s%04d", aliasName, SEP, index);
    }
}

