/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.aggregate.AggregateFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ElasticSearchNxqlPageProvider
extends CoreQueryDocumentPageProvider {
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String SEARCH_ON_ALL_REPOSITORIES_PROPERTY = "searchAllRepositories";
    public static final String ES_MAX_RESULT_WINDOW_PROPERTY = "org.nuxeo.elasticsearch.provider.maxResultWindow";
    public static final String DEFAULT_ES_MAX_RESULT_WINDOW_VALUE = "10000";
    protected static final Logger log = LogManager.getLogger(ElasticSearchNxqlPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected HashMap<String, Aggregate<? extends Bucket>> currentAggregates;
    protected Long maxResultWindow;

    public List<DocumentModel> getCurrentPage() {
        long t0 = System.currentTimeMillis();
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        this.error = null;
        this.errorMessage = null;
        log.debug("Perform query for provider '{}': with pageSize={}, offset={}", new Supplier[]{() -> ((ElasticSearchNxqlPageProvider)this).getName(), () -> ((ElasticSearchNxqlPageProvider)this).getMinMaxPageSize(), () -> ((ElasticSearchNxqlPageProvider)this).getCurrentPageOffset()});
        this.currentPageDocuments = new ArrayList();
        CoreSession coreSession = this.getCoreSession();
        if (this.query == null) {
            this.buildQuery(coreSession);
        }
        if (this.query == null) {
            throw new NuxeoException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        try {
            NxQueryBuilder nxQuery = new NxQueryBuilder(this.getCoreSession()).nxql(this.query).offset((int)this.getCurrentPageOffset()).limit(this.getLimit()).addAggregates(this.buildAggregates());
            if (this.searchOnAllRepositories()) {
                nxQuery.searchOnAllRepositories();
            }
            nxQuery.useUnrestrictedSession(this.useUnrestrictedSession());
            List highlightFields = this.getHighlights();
            if (highlightFields != null && !highlightFields.isEmpty()) {
                nxQuery.highlight(highlightFields);
            }
            EsResult ret = ess.queryAndAggregate(nxQuery);
            DocumentModelList dmList = ret.getDocuments();
            this.currentAggregates = new HashMap(ret.getAggregates().size());
            for (Aggregate<Bucket> agg : ret.getAggregates()) {
                this.currentAggregates.put(agg.getId(), agg);
            }
            this.setResultsCount(dmList.totalSize());
            this.currentPageDocuments = dmList;
        }
        catch (QueryParseException e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.fireSearchEvent(this.getCoreSession().getPrincipal(), this.query, this.currentPageDocuments, System.currentTimeMillis() - t0);
        return this.currentPageDocuments;
    }

    protected int getLimit() {
        int ret = (int)this.getMinMaxPageSize();
        if (ret == 0) {
            ret = (int)Long.min(this.getMaxResultWindow(), Integer.MAX_VALUE);
        }
        return ret;
    }

    public QueryBuilder getCurrentQueryAsEsBuilder() {
        String nxql = this.getCurrentQuery();
        return NxqlQueryConverter.toESQueryBuilder(nxql);
    }

    protected void pageChanged() {
        this.currentPageDocuments = null;
        this.currentAggregates = null;
        super.pageChanged();
    }

    public void refresh() {
        this.currentPageDocuments = null;
        this.currentAggregates = null;
        super.refresh();
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new NuxeoException("cannot find core session");
        }
        return coreSession;
    }

    private List<AggregateEsBase<? extends Aggregation, ? extends Bucket>> buildAggregates() {
        ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>> ret = new ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>>(this.getAggregateDefinitions().size());
        boolean skip = this.isSkipAggregates();
        for (AggregateDefinition def : this.getAggregateDefinitions()) {
            AggregateEsBase<? extends Aggregation, ? extends Bucket> agg = AggregateFactory.create(def, this.getSearchDocumentModel());
            if (skip && agg.getSelection().isEmpty()) continue;
            ret.add(AggregateFactory.create(def, this.getSearchDocumentModel()));
        }
        return ret;
    }

    protected boolean searchOnAllRepositories() {
        String value = (String)this.getProperties().get(SEARCH_ON_ALL_REPOSITORIES_PROPERTY);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean hasAggregateSupport() {
        return true;
    }

    public Map<String, Aggregate<? extends Bucket>> getAggregates() {
        this.getCurrentPage();
        return this.currentAggregates;
    }

    protected void incorporateAggregates(Map<String, Serializable> eventProps) {
        super.incorporateAggregates(eventProps);
        if (this.currentAggregates != null) {
            HashMap aggregateMatches = new HashMap();
            for (String key : this.currentAggregates.keySet()) {
                Aggregate<? extends Bucket> ag = this.currentAggregates.get(key);
                ArrayList buckets = new ArrayList();
                for (Bucket bucket : ag.getBuckets()) {
                    HashMap<String, Object> b = new HashMap<String, Object>();
                    b.put("key", bucket.getKey());
                    b.put("count", bucket.getDocCount());
                    buckets.add(b);
                }
                aggregateMatches.put(key, buckets);
            }
            eventProps.put("aggregatesMatches", aggregateMatches);
        }
    }

    public boolean isLastPageAvailable() {
        if (this.getResultsCount() + this.getPageSize() <= this.getMaxResultWindow()) {
            return super.isNextPageAvailable();
        }
        return false;
    }

    public boolean isNextPageAvailable() {
        if (this.getCurrentPageOffset() + 2L * this.getPageSize() <= this.getMaxResultWindow()) {
            return super.isNextPageAvailable();
        }
        return false;
    }

    public long getPageLimit() {
        return this.getMaxResultWindow() / this.getPageSize();
    }

    public long getMaxResultWindow() {
        if (this.maxResultWindow == null) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            String maxResultWindowStr = cs.getProperty(ES_MAX_RESULT_WINDOW_PROPERTY, DEFAULT_ES_MAX_RESULT_WINDOW_VALUE);
            try {
                this.maxResultWindow = Long.valueOf(maxResultWindowStr);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid maxResultWindow property value: %s for page provider: %s, fallback to default.", (Object)maxResultWindowStr, (Object)this.name);
                this.maxResultWindow = Long.valueOf(DEFAULT_ES_MAX_RESULT_WINDOW_VALUE);
            }
        }
        return this.maxResultWindow;
    }

    public long getResultsCountLimit() {
        return this.getMaxResultWindow();
    }

    public void setMaxResultWindow(long maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }
}

