/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.status;

import java.util.List;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchStatusProbe
implements Probe {
    public ProbeStatus run() {
        String[] indices = this.getIndexNames();
        try {
            ClusterHealthStatus clusterStatus = ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).getClient().getHealthStatus(indices);
            switch (clusterStatus) {
                case GREEN: 
                case YELLOW: {
                    return ProbeStatus.newSuccess((String)clusterStatus.toString());
                }
            }
            return ProbeStatus.newFailure((String)clusterStatus.toString());
        }
        catch (NuxeoException e) {
            return ProbeStatus.newError((Throwable)e);
        }
    }

    protected String[] getIndexNames() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        List<String> repositoryNames = ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).getRepositoryNames();
        String[] indices = new String[repositoryNames.size()];
        int i = 0;
        for (String repo : repositoryNames) {
            indices[i++] = esa.getIndexNameForRepository(repo);
        }
        return indices;
    }
}

