/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit.pageprovider;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.mongodb.audit.MongoDBAuditBackend;
import org.nuxeo.mongodb.audit.MongoDBAuditEntryReader;
import org.nuxeo.runtime.api.Framework;

public class MongoDBAuditPageProvider
extends AbstractPageProvider<LogEntry>
implements PageProvider<LogEntry> {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_QUERY = "{}";
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String UICOMMENTS_PROPERTY = "generateUIComments";

    public String toString() {
        return this.buildAuditFilter().toString();
    }

    protected CoreSession getCoreSession() {
        Object session = this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session instanceof CoreSession) {
            return (CoreSession)session;
        }
        return null;
    }

    protected void preprocessCommentsIfNeeded(List<LogEntry> entries) {
        CoreSession session;
        Serializable preprocess = (Serializable)this.getProperties().get(UICOMMENTS_PROPERTY);
        if (preprocess != null && "true".equalsIgnoreCase(preprocess.toString()) && (session = this.getCoreSession()) != null) {
            CommentProcessorHelper cph = new CommentProcessorHelper(session);
            cph.processComments(entries);
        }
    }

    public List<LogEntry> getCurrentPage() {
        long t0 = System.currentTimeMillis();
        Bson filter = this.buildAuditFilter();
        List<SortInfo> sortInfos = this.getSortInfos();
        ArrayList<Bson> sorts = new ArrayList<Bson>(sortInfos.size());
        for (SortInfo sortInfo : sortInfos) {
            String sortColumn = sortInfo.getSortColumn();
            if ("id".equals(sortColumn)) {
                sortColumn = "_id";
            }
            if (sortInfo.getSortAscending()) {
                sorts.add(Sorts.ascending((String[])new String[]{sortColumn}));
                continue;
            }
            sorts.add(Sorts.descending((String[])new String[]{sortColumn}));
        }
        MongoCollection<Document> auditCollection = this.getMongoDBBackend().getAuditCollection();
        FindIterable response = auditCollection.find(filter).sort(Sorts.orderBy(sorts)).skip((int)(this.getCurrentPageIndex() * this.pageSize)).limit((int)this.getMinMaxPageSize());
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        this.setResultsCount(auditCollection.count(filter));
        for (Document document : response) {
            entries.add(MongoDBAuditEntryReader.read(document));
        }
        this.preprocessCommentsIfNeeded(entries);
        CoreSession session = this.getCoreSession();
        if (session != null) {
            this.fireSearchEvent(session.getPrincipal(), filter.toString(), entries, System.currentTimeMillis() - t0);
        }
        return entries;
    }

    protected String getFixedPart() {
        WhereClauseDefinition whereClause = this.getDefinition().getWhereClause();
        if (whereClause == null) {
            return null;
        }
        String fixedPart = whereClause.getFixedPart();
        if (fixedPart == null || fixedPart.isEmpty()) {
            fixedPart = EMPTY_QUERY;
        }
        return fixedPart;
    }

    protected boolean allowSimplePattern() {
        return true;
    }

    protected MongoDBAuditBackend getMongoDBBackend() {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        AuditBackend backend = audit.getBackend();
        if (backend instanceof MongoDBAuditBackend) {
            return (MongoDBAuditBackend)backend;
        }
        throw new NuxeoException("Unable to use MongoDBAuditPageProvider if audit service is not configured to run with MongoDB");
    }

    protected Bson buildAuditFilter() {
        Bson filter;
        PageProviderDefinition def = this.getDefinition();
        Object[] params = this.getParameters();
        List quickFilters = this.getQuickFilters();
        String quickFiltersClause = "";
        if (quickFilters != null && !quickFilters.isEmpty()) {
            for (QuickFilter quickFilter : quickFilters) {
                String clause = quickFilter.getClause();
                if (!quickFiltersClause.isEmpty() && clause != null) {
                    quickFiltersClause = NXQLQueryBuilder.appendClause((String)quickFiltersClause, (String)clause);
                    continue;
                }
                quickFiltersClause = clause != null ? clause : "";
            }
        }
        WhereClauseDefinition whereClause = def.getWhereClause();
        MongoDBAuditBackend mongoDBBackend = this.getMongoDBBackend();
        if (whereClause == null) {
            if (!this.allowSimplePattern()) {
                throw new UnsupportedOperationException("This page provider requires a explicit Where Clause");
            }
            String originalPattern = def.getPattern();
            String pattern = quickFiltersClause.isEmpty() ? originalPattern : (StringUtils.containsIgnoreCase((CharSequence)originalPattern, (CharSequence)" WHERE ") ? NXQLQueryBuilder.appendClause((String)originalPattern, (String)quickFiltersClause) : originalPattern + " WHERE " + quickFiltersClause);
            String baseQuery = mongoDBBackend.expandQueryVariables(pattern, params);
            filter = mongoDBBackend.buildFilter(baseQuery, null);
        } else {
            String fixedPart = this.getFixedPart();
            if (StringUtils.isNotBlank((CharSequence)quickFiltersClause)) {
                fixedPart = StringUtils.isNotBlank((CharSequence)fixedPart) ? NXQLQueryBuilder.appendClause((String)fixedPart, (String)quickFiltersClause) : quickFiltersClause;
            }
            String baseQuery = mongoDBBackend.expandQueryVariables(fixedPart, params);
            filter = this.buildSearchFilter(baseQuery, whereClause.getPredicates(), this.getSearchDocumentModel());
        }
        return filter;
    }

    public void refresh() {
        this.setCurrentPageOffset(0L);
        super.refresh();
    }

    public long getResultsCount() {
        return this.resultsCount;
    }

    public List<SortInfo> getSortInfos() {
        List sortInfos = super.getSortInfos();
        for (SortInfo si : sortInfos) {
            if (!si.getSortColumn().startsWith("log.")) continue;
            si.setSortColumn(si.getSortColumn().substring(4));
        }
        return sortInfos;
    }

    private Bson buildFilter(PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        if (searchDocumentModel == null) {
            return new Document();
        }
        ArrayList<Bson> filters = new ArrayList<Bson>();
        for (PredicateDefinition predicate : predicates) {
            PredicateFieldDefinition[] fieldDef = predicate.getValues();
            Object[] val = new Object[fieldDef.length];
            for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                Object value = fieldDef[fidx].getXpath() != null ? searchDocumentModel.getPropertyValue(fieldDef[fidx].getXpath()) : searchDocumentModel.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
                if (value instanceof Calendar) {
                    value = ((Calendar)value).getTime();
                }
                val[fidx] = value;
            }
            if (!this.isNonNullParam(val)) continue;
            String op = predicate.getOperator();
            Object firstValue = val[0];
            String predicateParameter = predicate.getParameter();
            if (op.equalsIgnoreCase("IN")) {
                Object[] values;
                if (firstValue instanceof Iterable) {
                    ArrayList<String> l = new ArrayList<String>();
                    Iterable vals = (Iterable)firstValue;
                    for (Object v : vals) {
                        if (v == null) continue;
                        l.add(v.toString());
                    }
                    values = l.toArray(new String[l.size()]);
                } else if (firstValue instanceof Object[]) {
                    values = (String[])firstValue;
                } else {
                    throw new NuxeoException("IN operand required a list or an array as parameter");
                }
                filters.add(Filters.in((String)predicateParameter, (Object[])values));
                continue;
            }
            if (op.equalsIgnoreCase("BETWEEN")) {
                filters.add(Filters.gt((String)predicateParameter, (Object)firstValue));
                if (val.length <= 1) continue;
                filters.add(Filters.lt((String)predicateParameter, (Object)val[1]));
                continue;
            }
            if (">".equals(op)) {
                filters.add(Filters.gt((String)predicateParameter, (Object)firstValue));
                continue;
            }
            if (">=".equals(op)) {
                filters.add(Filters.gte((String)predicateParameter, (Object)firstValue));
                continue;
            }
            if ("<".equals(op)) {
                filters.add(Filters.lt((String)predicateParameter, (Object)firstValue));
                continue;
            }
            if ("<=".equals(op)) {
                filters.add(Filters.lte((String)predicateParameter, (Object)firstValue));
                continue;
            }
            filters.add(Filters.eq((String)predicateParameter, (Object)firstValue));
        }
        if (filters.isEmpty()) {
            return new Document();
        }
        return Filters.and(filters);
    }

    private Bson buildSearchFilter(String fixedPart, PredicateDefinition[] predicates, DocumentModel searchDocumentModel) {
        Document fixedFilter = Document.parse((String)fixedPart);
        BsonDocument filter = this.buildFilter(predicates, searchDocumentModel).toBsonDocument(BsonDocument.class, this.getMongoDBBackend().getAuditCollection().getCodecRegistry());
        if (fixedFilter.isEmpty()) {
            return filter;
        }
        if (filter.isEmpty()) {
            return fixedFilter;
        }
        return Filters.and((Bson[])new Bson[]{fixedFilter, filter});
    }

    private boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (!(v instanceof String ? !((String)v).isEmpty() : (v instanceof String[] ? ((String[])v).length > 0 : v != null))) continue;
            return true;
        }
        return false;
    }
}

