/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.ContextProvider;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory;
import org.nuxeo.ecm.directory.ldap.LDAPDynamicReferenceDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

public class LDAPDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(LDAPDirectory.class);
    public static final String DN_SPECIAL_ATTRIBUTE_KEY = "dn";
    protected Properties contextProperties;
    protected volatile SearchControls idSearchControls;
    protected volatile SearchControls searchControls;
    protected final LDAPDirectoryFactory factory;
    protected String baseFilter;
    protected ContextProvider testServer;

    public LDAPDirectory(LDAPDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor, LDAPReference.class);
        if (StringUtils.isEmpty((CharSequence)descriptor.getSearchBaseDn())) {
            throw new DirectoryException("searchBaseDn configuration is missing for directory " + this.getName());
        }
        this.factory = (LDAPDirectoryFactory)((Object)Framework.getService(LDAPDirectoryFactory.class));
    }

    public LDAPDirectoryDescriptor getDescriptor() {
        return (LDAPDirectoryDescriptor)this.descriptor;
    }

    protected void addReferences() {
        super.addReferences();
        Reference[] refs = this.getDescriptor().getLdapReferences();
        Arrays.stream(refs).forEach(arg_0 -> ((LDAPDirectory)this).addReference(arg_0));
    }

    public List<Reference> getReferences(String referenceFieldName) {
        return (List)this.references.get(referenceFieldName);
    }

    public void initialize() {
        super.initialize();
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        this.fieldMapper = new DirectoryFieldMapper(ldapDirectoryDesc.fieldMapping);
        this.contextProperties = this.computeContextProperties();
        this.baseFilter = ldapDirectoryDesc.getAggregatedSearchFilter();
        this.idSearchControls = this.computeIdSearchControls();
        this.searchControls = this.computeSearchControls();
        log.debug((Object)String.format("initialized LDAP directory %s with fields [%s] and references [%s]", this.getName(), StringUtils.join((Object[])this.getSchemaFieldMap().keySet().toArray(), (String)", "), StringUtils.join((Object[])this.references.keySet().toArray(), (String)", ")));
    }

    protected Properties computeContextProperties() {
        String bindDn;
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        Properties props = new Properties();
        LDAPServerDescriptor serverConfig = this.getServer();
        if (null == serverConfig) {
            throw new DirectoryException("LDAP server configuration not found: " + ldapDirectoryDesc.getServerName());
        }
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String ldapUrls = serverConfig.getLdapUrls();
        if (ldapUrls == null) {
            throw new DirectoryException("Server LDAP URL configuration is missing for directory " + this.getName());
        }
        props.put("java.naming.provider.url", ldapUrls);
        if (!this.getDescriptor().getFollowReferrals()) {
            props.put("java.naming.referral", "ignore");
        } else {
            props.put("java.naming.referral", "follow");
        }
        if (serverConfig.getConnectionTimeout() > -1) {
            if (!serverConfig.useSsl()) {
                props.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(serverConfig.getConnectionTimeout()));
            } else {
                log.warn((Object)"SSL connections do not operate correctly when used with the connection timeout parameter, disabling timout");
            }
        }
        if ((bindDn = serverConfig.getBindDn()) != null) {
            props.put("java.naming.security.principal", bindDn);
            props.put("java.naming.security.credentials", serverConfig.getBindPassword());
        }
        if (serverConfig.isPoolingEnabled()) {
            props.put("com.sun.jndi.ldap.connect.pool", "true");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple DIGEST-MD5");
            this.setSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", Integer.toString(serverConfig.getPoolingTimeout()));
        }
        if (!serverConfig.isVerifyServerCert() && serverConfig.useSsl) {
            props.put("java.naming.ldap.factory.socket", "org.nuxeo.ecm.directory.ldap.LDAPDirectory$TrustingSSLSocketFactory");
        }
        return props;
    }

    protected void setSystemProperty(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    protected SearchControls computeIdSearchControls() {
        LDAPDirectoryDescriptor desc = this.getDescriptor();
        SearchControls scts = new SearchControls();
        scts.setSearchScope(desc.getSearchScope());
        String idAttr = this.fieldMapper.getBackendField(this.getIdField());
        scts.setReturningAttributes(new String[]{idAttr});
        scts.setCountLimit(desc.getQuerySizeLimit());
        scts.setTimeLimit(desc.getQueryTimeLimit());
        return scts;
    }

    protected SearchControls computeSearchControls() {
        LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
        SearchControls scts = new SearchControls();
        scts.setSearchScope(ldapDirectoryDesc.getSearchScope());
        HashSet<String> attrs = new HashSet<String>();
        for (String fieldName : this.getSchemaFieldMap().keySet()) {
            if (this.references.containsKey(fieldName)) continue;
            attrs.add(this.fieldMapper.getBackendField(fieldName));
        }
        attrs.add("objectClass");
        for (Reference reference : this.getReferences()) {
            if (!(reference instanceof LDAPReference)) continue;
            LDAPReference ldapReference = (LDAPReference)reference;
            attrs.add(ldapReference.getStaticAttributeId(this.fieldMapper));
            attrs.add(ldapReference.getDynamicAttributeId());
            for (LDAPDynamicReferenceDescriptor dynAtt : ldapReference.getDynamicAttributes()) {
                attrs.add(dynAtt.baseDN);
                attrs.add(dynAtt.filter);
            }
        }
        if (this.getPasswordField() != null) {
            attrs.remove(this.getPasswordField());
        }
        scts.setReturningAttributes(attrs.toArray(new String[attrs.size()]));
        scts.setCountLimit(ldapDirectoryDesc.getQuerySizeLimit());
        scts.setTimeLimit(ldapDirectoryDesc.getQueryTimeLimit());
        return scts;
    }

    public SearchControls getIdSearchControls() {
        return this.idSearchControls;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean fetchAllAttributes) {
        if (fetchAllAttributes) {
            LDAPDirectoryDescriptor ldapDirectoryDesc = this.getDescriptor();
            SearchControls scts = new SearchControls();
            scts.setSearchScope(ldapDirectoryDesc.getSearchScope());
            return scts;
        }
        return this.searchControls;
    }

    protected DirContext createContext() {
        try {
            String serverName = this.getDescriptor().getServerName();
            if (StringUtils.isEmpty((CharSequence)serverName)) {
                throw new DirectoryException("server configuration is missing for directory " + this.getName());
            }
            LDAPServerDescriptor serverConfig = this.getServer();
            if (serverConfig.isDynamicServerList()) {
                String ldapUrls = serverConfig.getLdapUrls();
                this.contextProperties.put("java.naming.provider.url", ldapUrls);
            }
            return new InitialDirContext(this.contextProperties);
        }
        catch (NamingException e) {
            throw new DirectoryException("Cannot connect to LDAP directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public LDAPServerDescriptor getServer() {
        return this.factory.getServer(this.getDescriptor().getServerName());
    }

    public LDAPSession getSession() {
        LDAPSession session = new LDAPSession(this);
        this.addSession((Session)session);
        return session;
    }

    public String getBaseFilter() {
        String idField = this.getIdField();
        String idAttribute = this.getFieldMapper().getBackendField(idField);
        String idFilter = String.format("(%s=*)", idAttribute);
        if (this.baseFilter != null && !"".equals(this.baseFilter)) {
            if (this.baseFilter.startsWith("(")) {
                return String.format("(&%s%s)", this.baseFilter, idFilter);
            }
            return String.format("(&(%s)%s)", this.baseFilter, idFilter);
        }
        return idFilter;
    }

    public String addBaseFilter(String filter) {
        ArrayList<String> filters = new ArrayList<String>();
        String idFilter = '(' + this.getFieldMapper().getBackendField(this.getIdField()) + "=*)";
        filters.add(idFilter);
        if (StringUtils.isNotBlank((CharSequence)this.baseFilter)) {
            if (!this.baseFilter.startsWith("(")) {
                this.baseFilter = '(' + this.baseFilter + ')';
            }
            filters.add(this.baseFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filters.add(filter);
        }
        return "(&" + StringUtils.join(filters, (String)"") + ')';
    }

    protected ContextProvider getTestServer() {
        return this.testServer;
    }

    public void setTestServer(ContextProvider testServer) {
        this.testServer = testServer;
    }

    public static class TrustingSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public TrustingSSLSocketFactory() {
            try {
                SSLContext sslContext = SSLContext.getDefault();
                sslContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, new SecureRandom());
                this.factory = sslContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Unable to initialize the SSL context:  ", nsae);
            }
            catch (KeyManagementException kme) {
                throw new RuntimeException("Unable to register a trust manager:  ", kme);
            }
        }

        public static SocketFactory getDefault() {
            return TrustingSSLSocketFactoryHolder.INSTANCE;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.factory.createSocket(s, host, port, autoClose);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }

        private class TrustingX509TrustManager
        implements X509TrustManager {
            private TrustingX509TrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }

        private static class TrustingSSLSocketFactoryHolder {
            public static final TrustingSSLSocketFactory INSTANCE = new TrustingSSLSocketFactory();

            private TrustingSSLSocketFactoryHolder() {
            }
        }
    }
}

