/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.uidgen;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class KeyValueStoreUIDSequencer
extends AbstractUIDSequencer {
    public static final String STORE_NAME_PROPERTY = "nuxeo.uidseq.keyvaluestore.name";
    public static final String DEFAULT_STORE_NAME = "sequence";
    public static final String SEP = ".";
    protected String storeName;

    @Override
    public void init() {
        this.storeName = ((ConfigurationService)Framework.getService(ConfigurationService.class)).getProperty(STORE_NAME_PROPERTY);
        if (StringUtils.isBlank((CharSequence)this.storeName)) {
            this.storeName = DEFAULT_STORE_NAME;
        }
    }

    @Override
    public void dispose() {
    }

    protected KeyValueStore getStore() {
        KeyValueStore store = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(this.storeName);
        if (store == null) {
            throw new NuxeoException("Unknown key/value store: " + this.storeName);
        }
        return store;
    }

    protected String getKey(String key) {
        return this.getName() + SEP + key;
    }

    @Override
    public void initSequence(String key, long id) {
        this.getStore().put(this.getKey(key), Long.valueOf(id));
    }

    @Override
    public long getNextLong(String key) {
        return this.getStore().addAndGet(this.getKey(key), 1L);
    }

    @Override
    public List<Long> getNextBlock(String key, int blockSize) {
        ArrayList<Long> ret = new ArrayList<Long>(blockSize);
        long last = this.getStore().addAndGet(this.getKey(key), (long)blockSize);
        for (int i = blockSize - 1; i >= 0; --i) {
            ret.add(last - (long)i);
        }
        return ret;
    }
}

