/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.util.Collection;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.commons.lang3.StringUtils;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.versioning.VersioningPolicyFilter;
import org.nuxeo.ecm.platform.el.ELService;
import org.nuxeo.runtime.api.Framework;

public class StandardVersioningPolicyFilter
implements VersioningPolicyFilter {
    protected Collection<String> types;
    protected Collection<String> facets;
    protected Collection<String> schemas;
    protected String condition;

    public StandardVersioningPolicyFilter(Collection<String> types, Collection<String> facets, Collection<String> schemas, String condition) {
        this.types = types;
        this.facets = facets;
        this.schemas = schemas;
        this.condition = condition;
    }

    @Override
    public boolean test(DocumentModel previousDocument, DocumentModel currentDocument) {
        if (!this.types.isEmpty() && !this.types.contains(currentDocument.getType())) {
            return false;
        }
        DocumentType docType = currentDocument.getDocumentType();
        if (!this.schemas.isEmpty()) {
            if (this.schemas.stream().noneMatch(arg_0 -> ((DocumentType)docType).hasSchema(arg_0))) {
                return false;
            }
        }
        if (!this.facets.isEmpty()) {
            if (this.facets.stream().noneMatch(arg_0 -> ((DocumentType)docType).hasFacet(arg_0))) {
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.condition)) {
            String cond = StandardVersioningPolicyFilter.evaluateCondition(this.condition);
            ELContext context = ((ELService)Framework.getService(ELService.class)).createELContext();
            ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
            VariableMapper vm = context.getVariableMapper();
            ValueExpression previousDocExpr = expressionFactory.createValueExpression((Object)previousDocument, DocumentModel.class);
            ValueExpression currentDocExpr = expressionFactory.createValueExpression((Object)currentDocument, DocumentModel.class);
            ValueExpression userExpr = expressionFactory.createValueExpression((Object)ClientLoginModule.getCurrentPrincipal(), NuxeoPrincipal.class);
            vm.setVariable("previousDocument", previousDocExpr);
            vm.setVariable("currentDocument", currentDocExpr);
            vm.setVariable("document", currentDocExpr);
            vm.setVariable("principal", userExpr);
            vm.setVariable("currentUser", userExpr);
            ValueExpression ve = expressionFactory.createValueExpression(context, cond, Boolean.class);
            return Boolean.TRUE.equals(ve.getValue(context));
        }
        return true;
    }

    public static String evaluateCondition(String condition) {
        String cond = condition.trim();
        if (!(cond.startsWith("#{") || cond.startsWith("${") || cond.endsWith("}"))) {
            cond = "#{" + cond + "}";
        }
        String p1 = ".*previousDocument\\..+";
        String p2 = ".*previousDocument\\s*[!=]=\\s*null.*";
        if (cond.matches(p1) && !cond.matches(p2)) {
            cond = "#{previousDocument != null && (" + cond.substring(2, cond.length() - 1) + ")}";
        }
        return cond;
    }
}

