/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.usermanager.AbstractUMRootObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="groups")
public class GroupRootObject
extends AbstractUMRootObject<NuxeoGroup> {
    public static final String PAGE_PROVIDER_NAME = "nuxeo_groups_listing";

    @Override
    protected NuxeoGroup getArtifact(String id) {
        return this.um.getGroup(id);
    }

    @Override
    protected String getArtifactType() {
        return "group";
    }

    @Override
    protected void checkPrecondition(NuxeoGroup group) {
        this.checkCurrentUserCanCreateArtifact(group);
        this.checkGroupHasAName(group);
        this.checkGroupDoesNotAlreadyExists(group, this.um);
    }

    @Override
    protected NuxeoGroup createArtifact(NuxeoGroup group) {
        this.um.createGroup(group.getModel());
        return this.um.getGroup(group.getName());
    }

    private void checkGroupDoesNotAlreadyExists(NuxeoGroup group, UserManager um) {
        if (um.getGroup(group.getName()) != null) {
            throw new NuxeoException("Group already exists", 409);
        }
    }

    private void checkGroupHasAName(NuxeoGroup group) {
        if (group.getName() == null) {
            throw new NuxeoException("Group MUST have a name", 400);
        }
    }

    @Override
    boolean isAPowerUserEditableArtifact(NuxeoGroup artifact) {
        return GroupRootObject.isAPowerUserEditableGroup(artifact);
    }

    static boolean isAPowerUserEditableGroup(NuxeoGroup group) {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        return !um.getAdministratorsGroups().contains(group.getName());
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        return ppService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }
}

