/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.TransactionOperation;
import java.util.Arrays;
import java.util.List;

public class CommitTransactionOperation
extends TransactionOperation {
    private static final List<Integer> NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES = Arrays.asList(79, 100);

    public CommitTransactionOperation(WriteConcern writeConcern) {
        super(writeConcern);
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            return super.execute(binding);
        }
        catch (MongoException e) {
            this.addErrorLabels(e);
            throw e;
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        super.executeAsync(binding, new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t instanceof MongoException) {
                    CommitTransactionOperation.this.addErrorLabels((MongoException)t);
                }
                callback.onResult(result, t);
            }
        });
    }

    private void addErrorLabels(MongoException e) {
        if (CommitTransactionOperation.shouldAddUnknownTransactionCommitResultLabel(e)) {
            e.addLabel("UnknownTransactionCommitResult");
        }
    }

    static boolean shouldAddUnknownTransactionCommitResultLabel(Throwable t) {
        if (!(t instanceof MongoException)) {
            return false;
        }
        MongoException e = (MongoException)t;
        if (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoNotPrimaryException || e instanceof MongoNodeIsRecoveringException) {
            return true;
        }
        if (e instanceof MongoWriteConcernException) {
            return !NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES.contains(e.getCode());
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return "commitTransaction";
    }
}

