/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.events;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.management.events.CallStat;

public class EventStatsHolder {
    protected static boolean collectAsyncHandlersExecTime = false;
    protected static boolean collectSyncHandlersExecTime = false;
    protected static Map<String, CallStat> syncStats = new ConcurrentHashMap<String, CallStat>();
    protected static Map<String, CallStat> aSyncStats = new ConcurrentHashMap<String, CallStat>();

    private EventStatsHolder() {
    }

    public static boolean isCollectAsyncHandlersExecTime() {
        return collectAsyncHandlersExecTime;
    }

    public static void setCollectAsyncHandlersExecTime(boolean collectAsyncHandlersExecTime) {
        EventStatsHolder.collectAsyncHandlersExecTime = collectAsyncHandlersExecTime;
    }

    public static boolean isCollectSyncHandlersExecTime() {
        return collectSyncHandlersExecTime;
    }

    public static void setCollectSyncHandlersExecTime(boolean collectSyncHandlersExecTime) {
        EventStatsHolder.collectSyncHandlersExecTime = collectSyncHandlersExecTime;
    }

    public static void clearStats() {
        syncStats.clear();
        aSyncStats.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAsyncExec(EventListenerDescriptor desc, long delta) {
        if (!collectAsyncHandlersExecTime) {
            return;
        }
        String name = desc.getName();
        Map<String, CallStat> map = aSyncStats;
        synchronized (map) {
            CallStat stat = aSyncStats.get(name);
            if (stat == null) {
                String label = desc.asPostCommitListener().getClass().getSimpleName();
                label = desc.getIsAsync() ? label + "(async)" : label + "(sync)";
                stat = new CallStat(label);
                aSyncStats.put(name, stat);
            }
            stat.update(delta);
        }
    }

    public static void logSyncExec(EventListenerDescriptor desc, long delta) {
        if (!collectSyncHandlersExecTime) {
            return;
        }
        String name = desc.getName();
        syncStats.computeIfAbsent(name, k -> new CallStat(desc.asEventListener().getClass().getSimpleName())).update(delta);
    }

    public static String getAsyncHandlersExecTime() {
        return EventStatsHolder.getStringSummary(aSyncStats);
    }

    public static Map<String, CallStat> getAsyncHandlersCallStats() {
        return Collections.unmodifiableMap(aSyncStats);
    }

    public static String getSyncHandlersExecTime() {
        return EventStatsHolder.getStringSummary(syncStats);
    }

    public static Map<String, CallStat> getSyncHandlersCallStats() {
        return Collections.unmodifiableMap(syncStats);
    }

    protected static String getStringSummary(Map<String, CallStat> stats) {
        long totalTime = 0L;
        for (CallStat stat : stats.values()) {
            totalTime += stat.getAccumulatedTime();
        }
        if (totalTime == 0L) {
            totalTime = 1L;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, CallStat> en : stats.entrySet()) {
            String name = en.getKey();
            CallStat stat = en.getValue();
            sb.append(name);
            sb.append(" - ");
            sb.append(stat.getLabel());
            sb.append(" - ");
            sb.append(stat.getCallCount());
            sb.append(" calls - ");
            sb.append(stat.getAccumulatedTime());
            sb.append("ms - ");
            String pcent = String.format("%.2f", 100.0 * (double)stat.getAccumulatedTime() / (double)totalTime);
            sb.append(pcent);
            sb.append("%\n");
        }
        return sb.toString();
    }

    public static void resetHandlersExecTime() {
        EventStatsHolder.clearStats();
    }
}

