/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.status;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.status.ConnectStatusHolder;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.SubscriptionStatusType;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.runtime.api.Framework;

public class ConnectUpdateStatusInfo {
    protected static final String UNREGISTERED = "unregistered";
    protected static final String ONLINE_REGISTERED = "onlineregistered";
    protected static final String CONNECT_UNREACHABLE = "unreachable";
    protected static final String EXPIRED = "expired";
    protected String type;
    protected String bannerPath;
    protected Integer availableUpdateCount;
    protected String feedUrl;
    protected boolean registered;
    protected static Log log = LogFactory.getLog(ConnectUpdateStatusInfo.class);

    public static ConnectUpdateStatusInfo unregistered() {
        ConnectUpdateStatusInfo status = new ConnectUpdateStatusInfo();
        status.type = UNREGISTERED;
        status.setBannerPath("clientSideBanner");
        status.feedUrl = ConnectUpdateStatusInfo.buildFeedUrl(false);
        status.availableUpdateCount = 0;
        status.registered = false;
        return status;
    }

    public static ConnectUpdateStatusInfo ok() {
        ConnectUpdateStatusInfo status = new ConnectUpdateStatusInfo();
        status.type = ONLINE_REGISTERED;
        status.registered = true;
        return status;
    }

    public static ConnectUpdateStatusInfo connectServerUnreachable() {
        ConnectUpdateStatusInfo status = new ConnectUpdateStatusInfo();
        status.type = CONNECT_UNREACHABLE;
        status.setBannerPath("clientSideBanner");
        status.feedUrl = ConnectUpdateStatusInfo.buildFeedUrl(true);
        status.availableUpdateCount = 0;
        status.registered = true;
        return status;
    }

    public static ConnectUpdateStatusInfo notValid() {
        ConnectUpdateStatusInfo status = new ConnectUpdateStatusInfo();
        status.type = EXPIRED;
        status.setBannerPath("serverSideBanner");
        status.registered = true;
        return status;
    }

    protected static String buildFeedUrl(boolean registred) {
        StringBuffer sb = new StringBuffer();
        sb.append(Framework.getProperty((String)"org.nuxeo.connect.client.feedUrl", (String)ConnectUrlConfig.getBaseUrl()));
        sb.append("connect-gateway/jsonp/");
        if (registred) {
            sb.append("registered");
        } else {
            sb.append(UNREGISTERED);
        }
        sb.append("?product=");
        sb.append(PlatformVersionHelper.getPlatformFilter());
        if (registred) {
            sb.append("&instance=");
            try {
                sb.append(LogicalInstanceIdentifier.instance().getCLID1());
            }
            catch (LogicalInstanceIdentifier.NoCLID e) {
                log.error((Object)"Error in ConnectUpdateStatusInfo generation : No CLID is defined ...");
            }
        }
        sb.append("&callback=displayConnectUpdateStatus");
        return sb.toString();
    }

    public String getIdentifier() {
        try {
            return LogicalInstanceIdentifier.instance().getCLID1();
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            return "";
        }
    }

    public String getDistributionLabel() {
        return PlatformVersionHelper.getDistributionName().toUpperCase() + " " + PlatformVersionHelper.getDistributionVersion();
    }

    public String getDistributionName() {
        return PlatformVersionHelper.getDistributionName().toUpperCase();
    }

    public String getDistributionVersion() {
        return PlatformVersionHelper.getDistributionVersion();
    }

    protected int computeAvailableUpdateCount() {
        if (ConnectStatusHolder.instance().getStatus().isConnectServerUnreachable()) {
            return 0;
        }
        PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
        String targetPlatform = PlatformVersionHelper.getPlatformFilter();
        List pkgs = pm.listUpdatePackages(PackageType.HOT_FIX, targetPlatform);
        List localHotFixes = pm.listLocalPackages(PackageType.HOT_FIX);
        ArrayList<DownloadablePackage> applicablePkgs = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : pkgs) {
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)pkg, (String)targetPlatform)) continue;
            boolean isInstalled = false;
            for (DownloadablePackage localPkg : localHotFixes) {
                if (!localPkg.getId().equals(pkg.getId())) continue;
                isInstalled = true;
                break;
            }
            if (isInstalled) continue;
            applicablePkgs.add(pkg);
        }
        return applicablePkgs.size();
    }

    public String getBannerPath() {
        return this.bannerPath;
    }

    protected void setBannerPath(String bannerName) {
        this.bannerPath = !bannerName.startsWith("/") ? "/incl/" + bannerName : bannerName;
        if (!this.bannerPath.endsWith(".xhtml")) {
            this.bannerPath = this.bannerPath + ".xhtml";
        }
    }

    public int getAvailableUpdateCount() {
        if (this.availableUpdateCount == null) {
            this.availableUpdateCount = this.computeAvailableUpdateCount();
        }
        return this.availableUpdateCount;
    }

    public String getType() {
        return this.type;
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isExpired() {
        return ConnectStatusHolder.instance().getStatus().status() == SubscriptionStatusType.EXPIRED;
    }
}

