/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.runtime.ReloadHelper;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Operation(id="Service.HotReloadStudioSnapshot", category="Services", label="Hot Reload Studio Snapshot Package", description="Updates Studio project with latest snapshot.")
public class HotReloadStudioSnapshot {
    protected static final String IN_PROGRESS = "updateInProgress";
    protected static final String SUCCESS = "success";
    protected static final String ERROR = "error";
    protected static final String DEPENDENCY_MISMATCH = "DEPENDENCY_MISMATCH";
    public static final String ID = "Service.HotReloadStudioSnapshot";
    protected static volatile boolean updateInProgress = false;
    private static final Logger log = LogManager.getLogger(HotReloadStudioSnapshot.class);
    @Context
    protected CoreSession session;
    @Context
    protected PackageManager pm;
    @Param(name="validate", required=false)
    protected boolean validate = true;

    protected static synchronized boolean setInProgress(boolean inProgress) {
        if (updateInProgress == inProgress) {
            return false;
        }
        updateInProgress = inProgress;
        return true;
    }

    @OperationMethod
    public Blob run() throws Exception {
        try {
            if (!HotReloadStudioSnapshot.setInProgress(true)) {
                Blob blob = HotReloadStudioSnapshot.jsonHelper(IN_PROGRESS, "Update in progress.", null);
                return blob;
            }
            if (!this.session.getPrincipal().isAdministrator()) {
                Blob blob = HotReloadStudioSnapshot.jsonHelper(ERROR, "Must be Administrator to use this function.", null);
                return blob;
            }
            if (!Framework.isDevModeSet()) {
                Blob blob = HotReloadStudioSnapshot.jsonHelper(ERROR, "You must enable Dev mode to Hot reload your Studio Snapshot package.", null);
                return blob;
            }
            List pkgs = this.pm.listRemoteAssociatedStudioPackages();
            DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
            if (snapshotPkg == null) {
                Blob blob = HotReloadStudioSnapshot.jsonHelper(ERROR, "No Snapshot Package was found.", null);
                return blob;
            }
            Blob blob = this.hotReloadPackage(snapshotPkg);
            return blob;
        }
        catch (RuntimeException e) {
            throw new OperationException((Throwable)e);
        }
        finally {
            HotReloadStudioSnapshot.setInProgress(false);
        }
    }

    protected boolean shouldValidate() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (cs.isBooleanPropertyTrue("studio.snapshot.disablePkgValidation")) {
            return false;
        }
        return this.validate;
    }

    public Blob hotReloadPackage(DownloadablePackage remotePkg) {
        boolean useCompatReload;
        String packageId;
        if (this.shouldValidate()) {
            this.pm.flushCache();
            String targetPlatform = PlatformVersionHelper.getPlatformFilter();
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)remotePkg, (String)targetPlatform)) {
                return HotReloadStudioSnapshot.jsonHelper(ERROR, String.format("This package is not validated for your current platform: %s", targetPlatform), null);
            }
            PackageDependency[] pkgDeps = remotePkg.getDependencies();
            log.debug("{} target platforms: {}", new Supplier[]{() -> remotePkg, () -> ArrayUtils.toString((Object)remotePkg.getTargetPlatforms())});
            log.debug("{} dependencies: {}", new Supplier[]{() -> remotePkg, () -> ArrayUtils.toString((Object)pkgDeps)});
            packageId = remotePkg.getId();
            if (pkgDeps != null && pkgDeps.length > 0) {
                DependencyResolution resolution = this.pm.resolveDependencies(packageId, targetPlatform);
                if (resolution.isFailed() && targetPlatform != null) {
                    resolution = this.pm.resolveDependencies(packageId, null);
                }
                if (resolution.isFailed()) {
                    return HotReloadStudioSnapshot.jsonHelper(DEPENDENCY_MISMATCH, String.format("Dependency check has failed for package '%s' (%s)", packageId, resolution), null);
                }
                List pkgToInstall = resolution.getInstallPackageIds();
                if ((pkgToInstall == null || pkgToInstall.size() != 1 || !packageId.equals(pkgToInstall.get(0))) && resolution.requireChanges()) {
                    ArrayList<String> dependencies = new ArrayList<String>();
                    for (String dependency : resolution.getInstallPackageNames()) {
                        if (dependency.contains(remotePkg.getName())) continue;
                        dependencies.add(dependency);
                    }
                    return HotReloadStudioSnapshot.jsonHelper(DEPENDENCY_MISMATCH, "A dependency mismatch has been detected. Please check your Studio project settings and your server configuration.", dependencies);
                }
            }
        }
        if (!(useCompatReload = Framework.isBooleanPropertyTrue((String)"nuxeo.hotreload.compat.mechanism"))) {
            log.info("Use hot reload update mechanism");
            ReloadHelper.hotReloadPackage(remotePkg.getId());
            return HotReloadStudioSnapshot.jsonHelper(SUCCESS, "Studio package installed.", null);
        }
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            packageId = remotePkg.getId();
            LocalPackage pkg = pus.getPackage(packageId);
            if (pkg != null) {
                HotReloadStudioSnapshot.removePackage(pus, pkg);
            }
            DownloadingPackage downloadingPkg = this.pm.download(packageId);
            while (!downloadingPkg.isCompleted()) {
                log.debug("Downloading studio snapshot package: {}", (Object)packageId);
                Thread.sleep(100L);
            }
            log.info("Installing {}", (Object)packageId);
            pkg = pus.getPackage(packageId);
            if (pkg == null || PackageState.DOWNLOADED != pkg.getPackageState()) {
                throw new NuxeoException("Error while downloading studio snapshot " + pkg);
            }
            Task installTask = pkg.getInstallTask();
            try {
                HotReloadStudioSnapshot.performTask(installTask);
                return HotReloadStudioSnapshot.jsonHelper(SUCCESS, "Studio package installed.", null);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        catch (ConnectServerError | PackageException e) {
            throw new NuxeoException("Error while installing studio snapshot", e);
        }
    }

    protected static void removePackage(PackageUpdateService pus, LocalPackage pkg) throws PackageException {
        log.info("Removing package {} before update...", (Object)pkg.getId());
        if (pkg.getPackageState().isInstalled()) {
            log.info("Uninstalling {}", (Object)pkg.getId());
            Task uninstallTask = pkg.getUninstallTask();
            try {
                HotReloadStudioSnapshot.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
        }
        pus.removePackage(pkg.getId());
    }

    protected static void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> task.getPackage().getId();
            supplierArray[1] = () -> ((ValidationStatus)validationStatus).getWarnings();
            log.warn("Got warnings on package validation {} -> {}", supplierArray);
        }
        task.run(null);
    }

    protected static Blob jsonHelper(String status, String message, List<String> dependencies) {
        ArrayList result = new ArrayList();
        LinkedHashMap<String, Object> resultJSON = new LinkedHashMap<String, Object>();
        resultJSON.put("status", status);
        resultJSON.put("message", message);
        if (dependencies != null) {
            resultJSON.put("deps", dependencies);
        }
        result.add(resultJSON);
        try {
            return Blobs.createJSONBlobFromValue(result);
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to create json response", (Throwable)e);
        }
    }
}

