/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionLocationService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.UserWorkspaceDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserWorkspaceServiceImplComponent
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.platform.userworkspace.UserWorkspaceService";
    private static final Log log = LogFactory.getLog(UserWorkspaceService.class);
    protected Deque<UserWorkspaceDescriptor> descriptors = new LinkedList<UserWorkspaceDescriptor>();
    protected UserWorkspaceService userWorkspaceService;

    public void activate(ComponentContext context) {
        log.info((Object)"UserWorkspaceService activated");
    }

    public void deactivate(ComponentContext context) {
        log.info((Object)"UserWorkspaceService deactivated");
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == UserWorkspaceService.class) {
            return adapter.cast(this.getUserWorkspaceService());
        }
        if (adapter == CollectionLocationService.class) {
            return adapter.cast(this.getUserWorkspaceService());
        }
        return null;
    }

    private UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            Class<? extends UserWorkspaceService> klass = this.getConfiguration().getUserWorkspaceClass();
            if (klass == null) {
                throw new NuxeoException("No class specified for the userWorkspace");
            }
            try {
                this.userWorkspaceService = klass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to instantiate class " + klass, (Throwable)e);
            }
        }
        return this.userWorkspaceService;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.descriptors.add((UserWorkspaceDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.descriptors.remove(contribution);
    }

    protected void recompute() {
        this.userWorkspaceService = null;
    }

    public String getTargetDomainName() {
        return this.getConfiguration().getTargetDomainName();
    }

    public UserWorkspaceDescriptor getConfiguration() {
        return this.descriptors.getLast();
    }

    public static void reset() {
        UserWorkspaceServiceImplComponent s = (UserWorkspaceServiceImplComponent)((Object)Framework.getRuntime().getComponent(NAME));
        s.userWorkspaceService = null;
    }
}

