/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSFilter;
import com.thetransactioncompany.cors.Origin;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class NuxeoCorsCsrfFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoCorsCsrfFilter.class);
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";
    protected static final Set<String> SAFE_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE"));
    public static final String ORIGIN_NULL = "null";
    public static final URI PRIVACY_SENSITIVE = URI.create("privacy-sensitive:///");
    public static final List<String> SCHEMES_ALLOWED = Arrays.asList("moz-extension", "chrome-extension");
    public static final String ALLOW_NULL_ORIGIN_PROP = "nuxeo.cors.allowNullOrigin";
    public static final String ALLOW_NULL_ORIGIN_DEFAULT = "false";
    public static final String CSRF_TOKEN_NS_PROP = "nuxeo.csrf.token";
    public static final String CSRF_TOKEN_ENABLED_SUBPROP = "enabled";
    public static final String CSRF_TOKEN_ENABLED_DEFAULT = "false";
    public static final String CSRF_TOKEN_SKIP_SUBPROP = "skip";
    public static final String CSRF_TOKEN_ATTRIBUTE = "NuxeoCSRFToken";
    public static final String CSRF_TOKEN_HEADER = "CSRF-Token";
    public static final String CSRF_TOKEN_FETCH = "fetch";
    public static final String CSRF_TOKEN_INVALID = "invalid";
    public static final String CSRF_TOKEN_PARAM = "csrf-token";
    protected static final Random RANDOM = new SecureRandom();
    protected boolean allowNullOrigin;
    protected boolean csrfTokenEnabled;
    protected List<String> csrfTokenSkipPaths;

    public void init(FilterConfig filterConfig) {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        this.allowNullOrigin = Boolean.parseBoolean(configurationService.getProperty(ALLOW_NULL_ORIGIN_PROP, "false"));
        Map csrfTokenConfig = configurationService.getProperties(CSRF_TOKEN_NS_PROP);
        this.csrfTokenEnabled = Boolean.parseBoolean(StringUtils.defaultString((String)((String)csrfTokenConfig.get(CSRF_TOKEN_ENABLED_SUBPROP)), (String)"false"));
        this.csrfTokenSkipPaths = new ArrayList<String>();
        Serializable skipPaths = (Serializable)csrfTokenConfig.get(CSRF_TOKEN_SKIP_SUBPROP);
        if (skipPaths instanceof String[]) {
            this.csrfTokenSkipPaths.addAll(Arrays.asList((String[])skipPaths));
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean allow;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.manageCSRFToken(request, response)) {
            return;
        }
        RequestControllerManager service = (RequestControllerManager)Framework.getService(RequestControllerManager.class);
        CORSFilter corsFilter = service.getCorsFilterForRequest(request);
        CORSConfiguration corsConfig = corsFilter == null ? null : corsFilter.getConfiguration();
        String method = request.getMethod();
        URI sourceURI = this.getSourceURI(request);
        URI targetURI = this.getTargetURI(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method: " + method + ", source: " + sourceURI + ", target: " + targetURI));
        }
        if (this.isSafeMethod(method)) {
            log.debug((Object)"Safe method: allow");
            allow = true;
        } else if (this.sourceAndTargetMatch(sourceURI, targetURI)) {
            log.debug((Object)"Source and target match: allow");
            if (targetURI == null) {
                log.error((Object)"Cannot determine target URL for CSRF check");
            }
            allow = true;
        } else if (corsConfig == null) {
            log.debug((Object)"URL not covered by CORS config: disallow cross-site request");
            allow = false;
        } else if (!corsConfig.isAllowedOrigin(this.originFromURI(sourceURI))) {
            log.debug((Object)"Origin not allowed by CORS config: disallow cross-site request");
            allow = false;
        } else if (!corsConfig.isSupportedMethod(method)) {
            log.debug((Object)"Method not allowed by CORS config: disallow cross-site request");
            allow = false;
        } else {
            log.debug((Object)"Origin and method allowed by CORS config: allow cross-site request");
            allow = true;
        }
        if (allow) {
            if (corsFilter == null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                request = this.maybeIgnoreWhitelistedOrigin(request);
                corsFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
            return;
        }
        String message = "CSRF check failure";
        log.warn((Object)(message + ": source: " + sourceURI + " does not match target: " + targetURI + " and not allowed by CORS config"));
        response.sendError(403, message);
    }

    protected boolean isSafeMethod(String method) {
        return SAFE_METHODS.contains(method);
    }

    protected boolean manageCSRFToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token;
        String pathInfo;
        if (!this.csrfTokenEnabled) {
            log.debug((Object)"No CSRF token check configured");
            return false;
        }
        String method = request.getMethod();
        String path = request.getServletPath();
        if (path == null) {
            path = "";
        }
        if ((pathInfo = request.getPathInfo()) != null) {
            path = path + pathInfo;
        }
        String requestToken = request.getHeader(CSRF_TOKEN_HEADER);
        if (GET.equals(method) && path.isEmpty() && CSRF_TOKEN_FETCH.equals(requestToken)) {
            HttpSession session = request.getSession();
            String token2 = (String)session.getAttribute(CSRF_TOKEN_ATTRIBUTE);
            if (token2 == null) {
                token2 = this.generateNewToken();
                session.setAttribute(CSRF_TOKEN_ATTRIBUTE, (Object)token2);
            }
            log.debug((Object)"Returning CSRF token fetch");
            response.setHeader(CSRF_TOKEN_HEADER, token2);
            response.setStatus(200);
            return true;
        }
        if (this.isSafeMethod(method)) {
            log.debug((Object)"No CSRF token check on safe method");
            return false;
        }
        if (this.csrfTokenSkipPaths.contains(path)) {
            log.debug((Object)"No CSRF token check on configured endpoint");
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null || (token = (String)session.getAttribute(CSRF_TOKEN_ATTRIBUTE)) == null) {
            log.debug((Object)"Error, no session or no CSRF token in session");
            String message = "CSRF check failure";
            log.warn((Object)(message + ": invalid token"));
            response.setHeader(CSRF_TOKEN_HEADER, CSRF_TOKEN_INVALID);
            response.sendError(403, message);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)requestToken)) {
            requestToken = request.getParameter(CSRF_TOKEN_PARAM);
        }
        if (!token.equals(requestToken)) {
            log.debug((Object)"Error, CSRF token does not match");
            String message = "CSRF check failure";
            log.warn((Object)(message + ": invalid token"));
            response.setHeader(CSRF_TOKEN_HEADER, CSRF_TOKEN_INVALID);
            response.sendError(403, message);
            return true;
        }
        log.debug((Object)"CSRF token matches");
        return false;
    }

    protected String generateNewToken() {
        return RandomStringUtils.random((int)40, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)RANDOM);
    }

    public URI getSourceURI(HttpServletRequest request) {
        String source = request.getHeader("Origin");
        if (StringUtils.isBlank((CharSequence)source)) {
            source = request.getHeader("Referer");
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if (ORIGIN_NULL.equals(source = source.trim())) {
            return this.allowNullOrigin ? null : PRIVACY_SENSITIVE;
        }
        if (source.contains(" ")) {
            source = source.substring(0, source.indexOf(32));
        }
        try {
            return new URI(source);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getTargetURI(HttpServletRequest request) {
        String baseURL = VirtualHostHelper.getServerURL((ServletRequest)request, false);
        if (baseURL == null) {
            return null;
        }
        try {
            return new URI(baseURL);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean sourceAndTargetMatch(URI sourceURI, URI targetURI) {
        if (sourceURI == null || targetURI == null) {
            return true;
        }
        if (this.isWhitelistedScheme(sourceURI)) {
            return true;
        }
        return Objects.equals(sourceURI.getScheme(), targetURI.getScheme()) && Objects.equals(sourceURI.getHost(), targetURI.getHost()) && sourceURI.getPort() == targetURI.getPort();
    }

    protected Origin originFromURI(URI uri) {
        try {
            uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new Origin(uri.toString());
    }

    protected HttpServletRequest maybeIgnoreWhitelistedOrigin(HttpServletRequest request) {
        URI uri;
        String origin = request.getHeader("Origin");
        if (origin == null) {
            return request;
        }
        try {
            uri = new URI(origin);
        }
        catch (URISyntaxException e) {
            return request;
        }
        if (!this.isWhitelistedScheme(uri)) {
            return request;
        }
        return new IgnoredOriginRequestWrapper(request);
    }

    protected boolean isWhitelistedScheme(URI uri) {
        return SCHEMES_ALLOWED.contains(uri.getScheme());
    }

    public static class IgnoredOriginRequestWrapper
    extends HttpServletRequestWrapper {
        public IgnoredOriginRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            if ("Origin".equalsIgnoreCase(name)) {
                return null;
            }
            return super.getHeader(name);
        }
    }
}

