/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.RemoteHostGuessExtractor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class NuxeoRequestControllerFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoRequestControllerFilter.class);
    protected static final String SESSION_LOCK_KEY = "NuxeoSessionLockKey";
    protected static final String SYNCED_REQUEST_FLAG = "NuxeoSessionAlreadySync";
    protected static final int LOCK_TIMEOUT_S = 120;
    public static final FastDateFormat HTTP_EXPIRES_DATE_FORMAT = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public static String doFormatLogMessage(HttpServletRequest request, String info) {
        String remoteHost = RemoteHostGuessExtractor.getRemoteHost(request);
        Principal principal = request.getUserPrincipal();
        String principalName = principal != null ? principal.getName() : "none";
        String uri = request.getRequestURI();
        HttpSession session = request.getSession(false);
        String sessionId = session != null ? session.getId() : "none";
        String threadName = Thread.currentThread().getName();
        return "remote=" + remoteHost + ",principal=" + principalName + ",uri=" + uri + ",session=" + sessionId + ",thread=" + threadName + ",info=" + info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request;
        block31: {
            request = (HttpServletRequest)servletRequest;
            Object response = (HttpServletResponse)servletResponse;
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Entering NuxeoRequestController filter"));
            }
            RequestControllerManager rcm = (RequestControllerManager)Framework.getService(RequestControllerManager.class);
            RequestFilterConfig config = rcm.getConfigForRequest(request);
            boolean useSync = config.needSynchronization();
            boolean useTx = config.needTransaction();
            boolean useBuffer = config.needTransactionBuffered();
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Handling request with tx=" + useTx + " and sync=" + useSync + " and buffer=" + useBuffer));
            }
            this.addHeaders(request, (HttpServletResponse)response, config);
            boolean sessionSynched = false;
            boolean txStarted = false;
            boolean buffered = false;
            try {
                ServletHelper.setServletContext(request.getServletContext());
                if (useSync) {
                    sessionSynched = NuxeoRequestControllerFilter.simpleSyncOnSession(request);
                }
                if (useTx) {
                    if (!TransactionHelper.isTransactionActiveOrMarkedRollback() && !(txStarted = ServletHelper.startTransaction(request))) {
                        throw new ServletException("Failed to start transaction");
                    }
                    if (useBuffer) {
                        response = new BufferingHttpServletResponse((HttpServletResponse)response);
                        buffered = true;
                    }
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException | RuntimeException | ServletException e) {
                response.setStatus(500);
                if (TransactionHelper.isTransactionActive()) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                if (DownloadHelper.isClientAbortError((Throwable)e)) {
                    DownloadHelper.logClientAbort((Throwable)e);
                    break block31;
                }
                if (e instanceof RuntimeException) {
                    throw new ServletException(e);
                }
                throw e;
            }
            finally {
                try {
                    if (txStarted) {
                        try {
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        catch (TransactionRuntimeException e) {
                            response.setStatus(500);
                            log.error((Object)e, (Throwable)e);
                        }
                    }
                }
                finally {
                    if (buffered) {
                        ((BufferingHttpServletResponse)((Object)response)).stopBuffering();
                    }
                    if (sessionSynched) {
                        NuxeoRequestControllerFilter.simpleReleaseSyncOnSession(request);
                    }
                    ServletHelper.removeServletContext();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Exiting NuxeoRequestController filter"));
        }
    }

    public static boolean simpleSyncOnSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "HttpSession does not exist, this request won't be synched"));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Trying to sync on session "));
        }
        if (request.getAttribute(SYNCED_REQUEST_FLAG) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Request has already be synced, filter is reentrant, exiting without locking"));
            }
            return false;
        }
        Lock lock = (Lock)session.getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            lock = new ReentrantLock();
            session.setAttribute(SESSION_LOCK_KEY, (Object)lock);
        }
        boolean locked = false;
        try {
            locked = lock.tryLock(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        if (locked) {
            request.setAttribute(SYNCED_REQUEST_FLAG, (Object)true);
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Request synced on session"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Sync timeout"));
        }
        return locked;
    }

    public static boolean simpleReleaseSyncOnSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "No more HttpSession: can not unlock !, HttpSession must have been invalidated"));
            }
            return false;
        }
        log.debug((Object)("Trying to unlock on session " + session.getId() + " on Thread " + Thread.currentThread().getId()));
        Lock lock = (Lock)session.getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            log.error((Object)"Unable to find session lock, HttpSession may have been invalidated");
            return false;
        }
        lock.unlock();
        if (request.getAttribute(SYNCED_REQUEST_FLAG) != null) {
            request.removeAttribute(SYNCED_REQUEST_FLAG);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"session unlocked on Thread ");
        }
        return true;
    }

    protected void addHeaders(HttpServletRequest request, HttpServletResponse response, RequestFilterConfig config) {
        this.addConfiguredHeaders(response);
        if (request.getMethod().equals("GET")) {
            this.addCacheHeaders(response, config);
        }
    }

    protected void addConfiguredHeaders(HttpServletResponse response) {
        RequestControllerManager rcm = (RequestControllerManager)Framework.getService(RequestControllerManager.class);
        for (Map.Entry<String, String> en : rcm.getResponseHeaders().entrySet()) {
            String headerName = en.getKey();
            if (response.containsHeader(headerName)) continue;
            response.addHeader(headerName, en.getValue());
        }
    }

    protected void addCacheHeaders(HttpServletResponse response, RequestFilterConfig config) {
        if (config.isCached()) {
            String privateOrPublic = config.isPrivate() ? "private" : "public";
            response.setHeader("Cache-Control", privateOrPublic + ", max-age=" + config.getCacheTime());
            long expires = System.currentTimeMillis() + Long.parseLong(config.getCacheTime()) * 1000L;
            response.setHeader("Expires", HTTP_EXPIRES_DATE_FORMAT.format(expires));
        } else if (config.isPrivate()) {
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
    }
}

