/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.antisamy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.owasp.html.antisamy.Attribute;
import org.owasp.html.antisamy.Policy;
import org.owasp.html.antisamy.Tag;

public class Constants {
    public static final String DEFAULT_ENCODING_ALGORITHM = "UTF-8";
    public static final Tag BASIC_PARAM_TAG_RULE;
    public static List<String> defaultAllowedEmptyTags;
    public static List<String> defaultRequiresClosingTags;
    private static final String[] allowedEmptyTags;
    private static final String[] requiresClosingTags;
    public static final String DEFAULT_LOCALE_LANG = "en";
    public static final String DEFAULT_LOCALE_LOC = "US";
    public static final String big5CharsToEncode = "<>\"'&";
    public static final Set<Integer> big5CharsToEncodeSet;

    static {
        allowedEmptyTags = new String[]{"br", "hr", "a", "img", "link", "iframe", "script", "object", "applet", "frame", "base", "param", "meta", "input", "textarea", "embed", "basefont", "col"};
        requiresClosingTags = new String[]{"iframe", "script", "link"};
        Attribute paramNameAttr = new Attribute("name", Arrays.asList(Policy.ANYTHING_REGEXP), Collections.emptyList(), null, null);
        Attribute paramValueAttr = new Attribute("value", Arrays.asList(Policy.ANYTHING_REGEXP), Collections.emptyList(), null, null);
        HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
        attrs.put(paramNameAttr.getName().toLowerCase(), paramNameAttr);
        attrs.put(paramValueAttr.getName().toLowerCase(), paramValueAttr);
        BASIC_PARAM_TAG_RULE = new Tag("param", attrs, "validate");
        defaultAllowedEmptyTags = new ArrayList<String>();
        defaultAllowedEmptyTags.addAll(Arrays.asList(allowedEmptyTags));
        defaultRequiresClosingTags = new ArrayList<String>();
        defaultRequiresClosingTags.addAll(Arrays.asList(requiresClosingTags));
        big5CharsToEncodeSet = new HashSet<Integer>(){
            {
                for (int i = 0; i < Constants.big5CharsToEncode.length(); ++i) {
                    this.add(Integer.valueOf(Constants.big5CharsToEncode.charAt(i)));
                }
            }
        };
    }
}

