/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.PageProviderHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;

@Operation(id="Repository.Query", category="Fetch", label="Query", description="Perform a query on the repository. The document list returned will become the input for the next operation.If no provider name is given, a query returning all the documents that the user has access to will be executed.", since="6.0", addToStudio=true, aliases={"Document.Query"})
public class DocumentPaginatedQuery {
    public static final String ID = "Repository.Query";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    @Context
    protected CoreSession session;
    @Param(name="query", required=false, description="The query to perform.")
    protected String query;
    @Param(name="language", required=false, description="The query language.", widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="currentPageIndex", alias={"page"}, required=false, description="Target listing page.")
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false, description="Entries number per page.")
    protected Integer pageSize;
    @Param(name="queryParams", required=false, description="Ordered query parameters.")
    protected StringList strParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected StringList sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected StringList sortOrder;
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;
    @Param(name="maxResults", required=false)
    protected Integer maxResults;

    @OperationMethod
    public DocumentModelList run() throws OperationException {
        Long targetPage;
        Long targetPageSize;
        PageProviderDefinition def;
        PageProvider pp;
        PaginableDocumentModelListImpl res;
        if (this.query == null) {
            this.query = "SELECT * from Document";
        }
        Map<String, String> properties = null;
        if (this.maxResults != null) {
            properties = Collections.singletonMap("maxResults", this.maxResults.toString());
        }
        if ((res = new PaginableDocumentModelListImpl(pp = PageProviderHelper.getPageProvider((CoreSession)this.session, (PageProviderDefinition)(def = PageProviderHelper.getQueryPageProviderDefinition((String)this.query, properties)), (Map)this.namedParameters, (List)this.sortBy, (List)this.sortOrder, (Long)(targetPageSize = this.pageSize != null ? Long.valueOf(this.pageSize.longValue()) : null), (Long)(targetPage = this.currentPageIndex != null ? Long.valueOf(this.currentPageIndex.longValue()) : null), this.strParameters != null ? this.strParameters.toArray((Object[])new String[0]) : null))).hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }
}

